% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regroup.desc.R
\name{regroup}
\alias{regroup}
\alias{regroup.desc}
\title{Regroup two descriptive tables into one}
\usage{
regroup(x, y, ...)

\method{regroup}{desc}(x, y, rbind.label = "Response", ...)
}
\arguments{
\item{x}{A desc object}

\item{y}{A desc object}

\item{...}{Other parameters}

\item{rbind.label}{Character. The label for rbind column header}
}
\value{
A desc object corresponding to a table of statistics.
}
\description{
\code{regroup} 
regroup two descriptive tables (qualitative or quantitative) into one
}
\details{
Regroup a quantitative table and a qualitative table, is only possible if there is one and only one explicative variable.
So it works if and only if \code{x1} argument in \code{x} and \code{y} objects are not NULL, are the same 
and if \code{x2} argument is NULL in both \code{x} and \code{y} objects.

The function takes the y.label argument of object \code{x} and \code{y} respectively
as label for the levels of the new column created under the name of rbind.label (see example below)

It's also possible to regroup two quantitative tables, in this case it's possible if there is one or 
two explicative variables. 

For now it's not possible to regroup two qualitative tables.
}
\examples{

data(data)

# Example with a qualitative and a quantitative tables
#The argument y.label is stored in the desc object and 
# only used after by the regroup function

tab1=report.quanti(data=data,y="y_numeric",
	x1="GROUP",subjid="SUBJID",y.label="Y numeric")

tab2=report.quali(data=data,y="y_logistic",
	x1="GROUP",subjid="SUBJID",y.label="Y logistic")

regroup(tab1,tab2,rbind.label="The label of your choice")


# Example with 2 quantitative tables

tab1=report.quanti(data=data,y="y_numeric",
	x1="GROUP",subjid="SUBJID",y.label="Y numeric")

data$y_numeric2=rnorm(length(data$y_numeric))

tab2=report.quanti(data=data,y="y_numeric2",
	x1="GROUP",subjid="SUBJID",y.label="Y Numeric 2")

regroup(tab1,tab2,rbind.label="The label of your choice")

}
\seealso{
\code{\link{report.quali}} \code{\link{report.quanti}} \code{\link{report.doc}} \code{\link{desc}}
}
