% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomise.R
\name{randomise}
\alias{randomise}
\alias{randomize}
\title{Randomised group of items}
\usage{
randomise(ncomp = 3, nobservers = NULL, nitems = NULL,
  itemnames = NULL)
}
\arguments{
\item{ncomp}{an integer for the number of items each observer compares}

\item{nobservers}{an integer for the number of observers}

\item{nitems}{an integer for the number of items tested in the project}

\item{itemnames}{a character for the name of items tested in the project}
}
\value{
A dataframe with the randomised design
}
\description{
Set a randomised group of items for crowdsourcing citizen science.
Generate designs for ranking of options. It is designed for tricot trials 
specifically (comparing 3 options), but it will also work with comparisons 
of any other number of options. 
The design strives for approximate A optimality, this means that it is robust 
to missing observations. It also strives for balance for positions of each option.
Options are equally divided between first, second, third, etc. position. 
The strategy is to create a "pool" of combinations that does not repeat 
combinations and is A-optimal. Then this pool is ordered to make subsets of 
consecutive combinations also relatively balanced and A-optimal
}
\examples{
ni <- 3
no <- 10
nv <- 4
inames <- c("mango","banana","grape","apple")

randomise(ncomp = ni,
          nobservers = no,
          nitems = nv,
          itemnames = inames)
          
}
