% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{kbdi}
\alias{kbdi}
\title{Keetch-Byran Drought Index}
\usage{
kbdi(taverage, pr, data_names = NULL, time.scale = YEAR,
  na.rm = FALSE)
}
\arguments{
\item{taverage}{medium temperature}

\item{pr}{precipitation}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
KBDI
}
\description{
The Keetch-Byram Drought Index (KBDI) is an indicator of drought conditions and is used to predict wildfire severity.
}
\examples{
data(data_all)
kbdi(taverage = data_all$tg, pr=data_all$rr)
}
\references{
Keetch, J.J. and Byram, G.M. (1968). A drought index for forest fire control. Tech. Rep., USDA Forest Service Research Paper SE-38, North Carolina, USA. Alexander, M.E., 1990. Computer calculation of the Keetch-Byram Drought Index - programmers beware. Fire Management Notes 51, 23–25.
}
