% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeData.R
\name{mergeData}
\alias{mergeData}
\title{Merge data sources into input for CityWaterBalance}
\usage{
mergeData(area, atm, inflow, outflow, wu, ws_imports = NULL,
  etc_imports = NULL, wweff = NULL, dgr = NULL, cso = NULL,
  runoff = NULL, baseflow = NULL)
}
\arguments{
\item{area}{numeric study area (sq km)}

\item{atm}{xts of atmospheric data, from getAtmoFlows (mm/month)}

\item{inflow}{xts  of daily streamflow into area (cfs)}

\item{outflow}{xts of daily streamflow out of area (cfs)}

\item{wu}{xts of water use, from combineWaterUse (MGal/month)}

\item{ws_imports}{xts of imports for water supply (MGal/month)}

\item{etc_imports}{xts of other imports to surface water (MGal/month)}

\item{wweff}{xts of wastewater effluent (MGD)}

\item{dgr}{xts of deep groundwater recharge (mm/month)}

\item{cso}{xts of cso events (mm/month)}

\item{runoff}{xts of runoff (mm/month)}

\item{baseflow}{xts of baseflow (mm/month)}
}
\value{
all fluxes (as xts) for each timestep (mm/month)
}
\description{
This function converts units and merges data needed by CityWaterBalance.  
All inputs must represent the same time intervals. Outputs are fluxes 
(mm/month) over study area.
}
\examples{
\dontrun{
start <- "2010-01-01"
end <- "2010-12-31"
area <- 2707
atm <- getAtmoFlows(start, end, 'sample:Counties', 'STATE', 'RI', 41.5801)
inflow <- getStreamflow(start, end, c("01112500"))
inflow <- combineStreamflow(inflow, c(1))
outflow <- getStreamflow(start, end, c("01113895", "01114000", "01117000",
"01118500"))
outflow <- combineStreamflow(outflow, c(1, 1, 1, 1))
wu <- getWaterUse(c('RI'), 'ALL')
wu <- combineWaterUse(start, end, wu)
data <- mergeData(area, atm, inflow, outflow, wu)
}
}
