% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_circMLE.r
\name{plot_circMLE}
\alias{plot_circMLE}
\title{plot_circMLE}
\usage{
plot_circMLE(data, table, model, bins, shrink, col, lwd, lty)
}
\arguments{
\item{data}{A vector of class 'circular'}

\item{table}{A list containing the output from the circ_mle function}

\item{model}{The name of the model to be plotted. (default = first model of "table")}

\item{bins}{The number of bins for the circular histogram. (defualt = 18)}

\item{shrink}{The value by which to shrink the size of the plotted circle.
Larger numbers shrink the circle, smaller numbers expand the circle.
(default = 1.5)}

\item{col}{Vector of colors used for plotting, up to four colors can be specified.
The order is: histogram color, mean vector color, model density color, predicted
mean direction(s) color(s). (default = c("grey", "red", "black", "black"))}

\item{lwd}{Vector of line weights used for plotting, up to 3 weights can be
specified. The order is: mean vector weight, model density weight, predicted
mean direction(s) weight(s). (default = c(2, 2, 2))}

\item{lty}{Vector of line weights used for plotting, up to 3 weights can be
specified. The order is: mean vector weight, model density weight, predicted
mean direction(s) weight(s). (default = c("solid", "dashed", "dashed"))}
}
\value{
A plot is returned to the default image device.
}
\description{
Plot the observed data and specific model from circ_mle output
}
\note{
In the resulting plot, the observed vector length is equal to rho
(vector strength). However, the predicted direction(s) from the model are
drawn with vector length of 1. Also, if the model "M1" is selected, by
definition no predicted direction is plotted.
}
\examples{
testdata = circular::rvonmises(100, mu = circular::circular(pi), kappa = 3)
out = circ_mle(testdata)
plot_circMLE(testdata, out)
plot_circMLE(testdata, out, model = "M4A")
}
\keyword{plot_circMLE}
