% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circ_mle.r
\name{circ_mle}
\alias{circ_mle}
\title{circ_mle}
\usage{
circ_mle(data, criterion = "AIC", nchains = 5, BadStart = 10^9,
  niter = 5000, method = "BFGS")
}
\arguments{
\item{data}{A vector of class 'circular'}

\item{criterion}{chose from either "AIC", "AICc", or "BIC" for the
model comparison information criterion. (default = "AIC")}

\item{nchains}{A positive integer indicating the number of chains to run.
Only the chain with the lowest log likelihood is returned (default = 5)}

\item{BadStart}{An integer to replace the log likelihood when starting
parameters of the optimizer fall outside the preset bounds.  This is
usually set to a large number. Can also be set to Inf, but will
result in an error if a method other than "Nelder-Mead" is chosen. (default = 10^9)}

\item{niter}{The maximum number of iterations for the optimizing
algorithm.  Equivalent to the 'maxit' control parameter of the
optim() function.  See ?optim for more details. (default = 5000)}

\item{method}{A character string indicating the optimizing algorithm
to use.  Either "BFGS" or "Nelder-Mead" are recommended. See ?optim
for more details. (default = "BFGS")}
}
\value{
A list with 3 elements:

$results: A data frame consisting of a row for each model (rownames) with the columns:
1 = number of free parameters, 2 = mu1, 3 = kappa1, 4 = lamda, 5 = mu2, 6 = kappa2,
7 = negative log likelihood, 8 = Counts.function, 9 = Counts.Gradient,
10 = convergence, 11 = message. See ?optim for details on columns 8-10.

$bestmodel:  The best model according to the criterion chosen

$rt:  A two-element vector giving the test statistic and p-value for the Rayleigh Test
}
\description{
Run all 10 maximum likelihood models of circular orientation
}
\examples{
testdata = circular::rvonmises(100, mu = circular::circular(pi), kappa = 3)
circ_mle(testdata)
}
\keyword{circ_mle}
