% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landsberg_model.R
\name{landsberg_model}
\alias{landsberg_model}
\title{Landsberg Model}
\usage{
landsberg_model(x, total = TRUE)
}
\arguments{
\item{x}{Vector containing temperature values (Celsius-degree).}

\item{total}{TRUE Shows the total value of accumulation, FALSE shows the value of chill-unit for each temperature (TRUE is default).}
}
\value{
The function returns values the chill for each temperature of vector (Total = FALSE), or returns the chill accumulation (Total = TRUE).
}
\description{
Quantifies the chill accumulation based in the base temperature.
}
\details{
The model is based on the subtraction of the base temperature of each hourly temperature. The temperature of the base is 5°C.
}
\examples{

x <- rnorm(500, 8, 5)
landsberg_model(x)
landsberg_model(x, FALSE)

}
\references{
LANDSBERG J. J. (1974). Apple Fruit Bud Development and Growth; Analysis and an Empirical Model. Annals of Botany.
}
