% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeToEvent.R
\name{computeTimeToEventAnalyses}
\alias{computeTimeToEventAnalyses}
\title{Compute time to event study}
\usage{
computeTimeToEventAnalyses(
  connectionDetails = NULL,
  targetDatabaseSchema,
  targetTable,
  outcomeDatabaseSchema = targetDatabaseSchema,
  outcomeTable = targetTable,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  cdmDatabaseSchema,
  settings,
  databaseId = "database 1",
  outputFolder,
  minCellCount = 0,
  ...
)
}
\arguments{
\item{connectionDetails}{An object of type `connectionDetails` as created using the
[DatabaseConnector::createConnectionDetails()] function.}

\item{targetDatabaseSchema}{Schema name where your target cohort table resides. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{targetTable}{Name of the target cohort table.}

\item{outcomeDatabaseSchema}{Schema name where your outcome cohort table resides. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{outcomeTable}{Name of the outcome cohort table.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support temp tables.
To emulate temp tables, provide a schema with write privileges where temp tables
can be created}

\item{cdmDatabaseSchema}{The database schema containing the OMOP CDM data}

\item{settings}{The settings for the timeToEvent study}

\item{databaseId}{An identifier for the database (string)}

\item{outputFolder}{A directory to save the results as csv files}

\item{minCellCount}{The minimum cell value to display, values less than this will be replaced by -1}

\item{...}{extra inputs}
}
\value{
An \code{Andromeda::andromeda()} object containing the time to event results.
}
\description{
Compute time to event study
}
\examples{
# example code

conDet <- exampleOmopConnectionDetails()

tteSet <- createTimeToEventSettings(
  targetIds = c(1,2),
  outcomeIds = 3
)

result <- computeTimeToEventAnalyses(
  connectionDetails = conDet,
  targetDatabaseSchema = 'main',
  targetTable = 'cohort',
  cdmDatabaseSchema = 'main',
  settings = tteSet,
  outputFolder = file.path(tempdir(), 'tte')
)



}
\seealso{
Other TimeToEvent: 
\code{\link{createTimeToEventSettings}()}
}
\concept{TimeToEvent}
