# Mapping for built-in models works 

    [
      "",
      " Model Overview ",
      " ------------------------------------------- ",
      "Model Name        :  pkmodel",
      "Is population     :  TRUE",
      "Model Type        :  PK",
      "",
      " PK ",
      " ------------------------------------------- ",
      "Parameterization  :  Clearance",
      "Absorption        :  Intravenous",
      "Num Compartments  :  3",
      "Dose Tlag?        :  FALSE",
      "Elimination Comp ?:  FALSE",
      "Infusion Allowed ?:  FALSE",
      "Sequential        :  FALSE",
      "Freeze PK         :  FALSE",
      "",
      " PML ",
      " ------------------------------------------- ",
      "test(){",
      "    cfMicro(A1,Cl/V, Cl2/V, Cl2/V2, Cl3/V, Cl3/V3)",
      "    dosepoint(A1)",
      "    C = A1 / V",
      "    error(CEps=0.1)",
      "    observe(CObs=C * ( 1 + CEps))",
      "    stparm(V = tvV * exp(nV))",
      "    stparm(Cl = tvCl * exp(nCl))",
      "    stparm(V2 = tvV2 * exp(nV2))",
      "    stparm(Cl2 = tvCl2 * exp(nCl2))",
      "    stparm(V3 = tvV3 * exp(nV3))",
      "    stparm(Cl3 = tvCl3 * exp(nCl3))",
      "    fixef( tvV = c(,1,))",
      "    fixef( tvCl = c(,1,))",
      "    fixef( tvV2 = c(,1,))",
      "    fixef( tvCl2 = c(,1,))",
      "    fixef( tvV3 = c(,1,))",
      "    fixef( tvCl3 = c(,1,))",
      "    ranef(diag(nV,nCl,nV2,nCl2,nV3,nCl3) =  c(1,1,1,1,1,1))",
      "}",
      "",
      " Structural Parameters ",
      " ------------------------------------------- ",
      " V Cl V2 Cl2 V3 Cl3",
      " ------------------------------------------- ",
      "Observations:",
      "Observation Name :  CObs",
      "Effect Name      :  C",
      "Epsilon Name     :  CEps",
      "Epsilon Type     :  Multiplicative",
      "Epsilon frozen   :  FALSE",
      "is BQL           :  FALSE",
      " ------------------------------------------- ",
      " Column Mappings ",
      " ------------------------------------------- ",
      "Model Variable Name : Data Column name",
      "id                  : Subject,ID2",
      "time                : Act_Time",
      "A1                  : Amount",
      "CObs                : Conc",
      ""
    ]

---

    [
      "",
      " Model Overview ",
      " ------------------------------------------- ",
      "Model Name        :  linearmodel",
      "Is population     :  TRUE",
      "Model Type        :  LINEAR",
      "",
      " Linear ",
      " ------------------------------------------- ",
      "Linear Type       :  E = EAlpha + EBeta*C ",
      "Linear Frozen     :  FALSE",
      "Effect Compartment:  FALSE",
      "",
      " PML ",
      " ------------------------------------------- ",
      "test(){",
      "    covariate(C)",
      "    E = EAlpha + EBeta*C",
      "    error(EEps=1)",
      "    observe(EObs(C)=E + EEps)",
      "    stparm(EAlpha = tvEAlpha * exp(nEAlpha))",
      "    stparm(EBeta = tvEBeta * exp(nEBeta))",
      "    fixef( tvEAlpha = c(,1,))",
      "    fixef( tvEBeta = c(,1,))",
      "    ranef(diag(nEAlpha,nEBeta) =  c(1,1))",
      "}",
      "",
      " Structural Parameters ",
      " ------------------------------------------- ",
      " EAlpha EBeta",
      " ------------------------------------------- ",
      "Observations:",
      "Observation Name :  EObs",
      "Effect Name      :  E",
      "Epsilon Name     :  EEps",
      "Epsilon Type     :  Additive",
      "Epsilon frozen   :  FALSE",
      "is BQL           :  FALSE",
      " ------------------------------------------- ",
      " Column Mappings ",
      " ------------------------------------------- ",
      "Model Variable Name : Data Column name",
      "id                  : ID",
      "C                   : CObs",
      "EObs                : EObs",
      ""
    ]

---

    [
      "",
      " Model Overview ",
      " ------------------------------------------- ",
      "Model Name        :  emaxmodel",
      "Is population     :  TRUE",
      "Model Type        :  EMAX",
      "",
      " PD ",
      " ------------------------------------------- ",
      "Check Baseline    :  TRUE",
      "Check Inhibitory  :  TRUE",
      "Check Sigmoid     :  FALSE",
      "Check Fractional  :  TRUE",
      "Effect Compartment:  FALSE",
      "Freeze PD         :  FALSE",
      "",
      " PML ",
      " ------------------------------------------- ",
      "test(){",
      "    covariate(C)",
      "    E = E0 * (1 - Imax * C / (IC50 + C))",
      "    error(EEps=1)",
      "    observe(EObs(C)=E + EEps)",
      "    stparm(IC50 = tvIC50 * exp(nIC50))",
      "    stparm(E0 = tvE0 * exp(nE0))",
      "    stparm(Imax = tvImax * exp(nImax))",
      "    fixef( tvIC50 = c(,1,))",
      "    fixef( tvE0 = c(,1,))",
      "    fixef( tvImax = c(,1,))",
      "    ranef(diag(nIC50,nE0,nImax) =  c(1,1,1))",
      "}",
      "",
      " Structural Parameters ",
      " ------------------------------------------- ",
      " IC50 E0 Imax",
      " ------------------------------------------- ",
      "Observations:",
      "Observation Name :  EObs",
      "Effect Name      :  E",
      "Epsilon Name     :  EEps",
      "Epsilon Type     :  Additive",
      "Epsilon frozen   :  FALSE",
      "is BQL           :  FALSE",
      " ------------------------------------------- ",
      " Column Mappings ",
      " ------------------------------------------- ",
      "Model Variable Name : Data Column name",
      "id                  : ID",
      "C                   : CObs",
      "EObs                : EObs",
      ""
    ]

---

    [
      "",
      " Model Overview ",
      " ------------------------------------------- ",
      "Model Name        :  pklinearmodel",
      "Is population     :  TRUE",
      "Model Type        :  PK_LINEAR",
      "",
      " PK ",
      " ------------------------------------------- ",
      "Parameterization  :  Micro",
      "Absorption        :  Intravenous",
      "Num Compartments  :  1",
      "Dose Tlag?        :  FALSE",
      "Elimination Comp ?:  FALSE",
      "Infusion Allowed ?:  FALSE",
      "Sequential        :  TRUE",
      "Freeze PK         :  FALSE",
      "",
      " Linear ",
      " ------------------------------------------- ",
      "Linear Type       :  E = EAlpha ",
      "Linear Frozen     :  FALSE",
      "Effect Compartment:  FALSE",
      "",
      " PML ",
      " ------------------------------------------- ",
      "test(){",
      "    cfMicro(A1, Ke)",
      "    dosepoint(A1)",
      "    C = A1 / V",
      "    E = EAlpha",
      "    error(EEps=1)",
      "    observe(EObs=E + EEps)",
      "    stparm(V = tvV * exp(nV))",
      "    stparm(Ke = tvKe * exp(nKe))",
      "    stparm(EAlpha = tvEAlpha * exp(nEAlpha))",
      "    fixef( tvV(freeze) = c(,1,))",
      "    fixef( tvKe(freeze) = c(,1,))",
      "    fixef( tvEAlpha = c(,1,))",
      "    covariate(nV,nKe)",
      "    ranef(diag(nEAlpha) =  c(1))",
      "}",
      "",
      " Structural Parameters ",
      " ------------------------------------------- ",
      " V Ke EAlpha",
      " ------------------------------------------- ",
      "Observations:",
      "Observation Name :  EObs",
      "Effect Name      :  E",
      "Epsilon Name     :  EEps",
      "Epsilon Type     :  Additive",
      "Epsilon frozen   :  FALSE",
      "is BQL           :  FALSE",
      " ------------------------------------------- ",
      " Column Mappings ",
      " ------------------------------------------- ",
      "Model Variable Name : Data Column name",
      "id                  : ID",
      "time                : Time",
      "A1                  : Dose",
      "EObs                : EObs",
      "nV                  : nV",
      "nKe                 : nKe",
      ""
    ]

---

    [
      "",
      " Model Overview ",
      " ------------------------------------------- ",
      "Model Name        :  Sequential",
      "Is population     :  TRUE",
      "Model Type        :  PK_EMAX",
      "",
      " PK ",
      " ------------------------------------------- ",
      "Parameterization  :  Micro",
      "Absorption        :  Gamma",
      "Num Compartments  :  3",
      "Dose Tlag?        :  FALSE",
      "Elimination Comp ?:  TRUE",
      "Fraction Excreted :  FALSE",
      "Infusion Allowed ?:  FALSE",
      "Sequential        :  TRUE",
      "Freeze PK         :  FALSE",
      "",
      " PD ",
      " ------------------------------------------- ",
      "Check Baseline    :  TRUE",
      "Check Inhibitory  :  TRUE",
      "Check Sigmoid     :  TRUE",
      "Check Fractional  :  TRUE",
      "Effect Compartment:  FALSE",
      "Freeze PD         :  FALSE",
      "",
      " PML ",
      " ------------------------------------------- ",
      "test(){",
      "    dosepoint(A1)",
      "    C = A1 / V",
      "    delayInfCpt(A1, MeanDelayTime, ShapeParamMinusOne, out =  -  Ke * A1  -  K12 * A1 +  K21 * A2  -  K13 * A1 +  K31 * A3, dist = Gamma)",
      "    deriv(A2 =  K12 * A1  -  K21 * A2)",
      "    deriv(A3 =  K13 * A1  -  K31 * A3)",
      "    urinecpt(A0 =  Ke * A1)",
      "    E = E0 * (1 - Imax * C^Gam / (IC50^Gam + C^Gam))",
      "    error(A0Eps(freeze)=0.1)",
      "    observe(A0Obs=A0 * ( 1 + A0Eps))",
      "    error(EEps=1)",
      "    observe(EObs=E + EEps)",
      "    stparm(MeanDelayTime = tvMeanDelayTime * exp(nMeanDelayTime))",
      "    stparm(ShapeParamMinusOne = tvShapeParamMinusOne * exp(nShapeParamMinusOne))",
      "    stparm(V = tvV * exp(nV))",
      "    stparm(Ke = tvKe * exp(nKe))",
      "    stparm(K12 = tvK12 * exp(nK12))",
      "    stparm(K21 = tvK21 * exp(nK21))",
      "    stparm(K13 = tvK13 * exp(nK13))",
      "    stparm(K31 = tvK31 * exp(nK31))",
      "    stparm(IC50 = tvIC50 * exp(nIC50))",
      "    stparm(Gam = tvGam * exp(nGam))",
      "    stparm(E0 = tvE0 * exp(nE0))",
      "    stparm(Imax = tvImax * exp(nImax))",
      "    fixef( tvMeanDelayTime(freeze) = c(,1,))",
      "    fixef( tvShapeParamMinusOne(freeze) = c(,1,))",
      "    fixef( tvV(freeze) = c(,1,))",
      "    fixef( tvKe(freeze) = c(,1,))",
      "    fixef( tvK12(freeze) = c(,1,))",
      "    fixef( tvK21(freeze) = c(,1,))",
      "    fixef( tvK13(freeze) = c(,1,))",
      "    fixef( tvK31(freeze) = c(,1,))",
      "    fixef( tvIC50 = c(,1,))",
      "    fixef( tvGam = c(,1,))",
      "    fixef( tvE0 = c(,1,))",
      "    fixef( tvImax = c(,1,))",
      "    covariate(nMeanDelayTime,nShapeParamMinusOne,nV,nKe,nK12,nK21,nK13,nK31)",
      "    ranef(diag(nIC50,nGam,nE0,nImax) =  c(1,1,1,1))",
      "}",
      "",
      " Structural Parameters ",
      " ------------------------------------------- ",
      " MeanDelayTime ShapeParamMinusOne V Ke K12 K21 K13 K31 IC50 Gam E0 Imax",
      " ------------------------------------------- ",
      "Observations:",
      "Observation Name :  A0Obs",
      "Effect Name      :  A0",
      "Epsilon Name     :  A0Eps",
      "Epsilon Type     :  Multiplicative",
      "Epsilon frozen   :  TRUE",
      "is BQL           :  FALSE",
      " ------------------------------------------- ",
      "Observation Name :  EObs",
      "Effect Name      :  E",
      "Epsilon Name     :  EEps",
      "Epsilon Type     :  Additive",
      "Epsilon frozen   :  FALSE",
      "is BQL           :  FALSE",
      " ------------------------------------------- ",
      " Column Mappings ",
      " ------------------------------------------- ",
      "Model Variable Name : Data Column name",
      "id                  : Subject",
      "time                : Nom_Time",
      "A1                  : Amount",
      "A0Obs               : Gender",
      "EObs                : Age",
      "nMeanDelayTime      : nMeanDelayTime",
      "nShapeParamMinusOne : nShapeParamMinusOne",
      "nV                  : nV",
      "nKe                 : nKe",
      "nK12                : nK12",
      "nK21                : nK21",
      "nK13                : nK13",
      "nK31                : nK31",
      ""
    ]

