% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_StParm.R
\name{list_StParms}
\alias{list_StParms}
\title{List Structural Parameters in the currrent PML set}
\usage{
list_StParms(PMLParametersSets, IncludeAll = FALSE, IncludeCustom = TRUE)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{IncludeAll}{Logical. Should the names of structural parameters with
\code{None} state be included or not. Default is \code{FALSE}.}

\item{IncludeCustom}{Logical. Should the names of custom \code{stparm} statements
(from the PML code of custom spaces) be included or not. Default is \code{TRUE}.}
}
\value{
A character vector containing the names of structural parameters.
}
\description{
This function lists the names of structural parameters in a given set of
PMLParametersSets.
}
\examples{
PMLParametersSets <- get_PMLParametersSets()
list_StParms(PMLParametersSets)

}
\seealso{
\code{\link[=add_StParm]{add_StParm()}} \code{\link[=modify_StParm]{modify_StParm()}}
}
