% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_model.R
\name{update_model}
\alias{update_model}
\title{Fit causal model using 'stan'}
\usage{
update_model(
  model,
  data = NULL,
  data_type = NULL,
  keep_fit = FALSE,
  keep_transformed = TRUE,
  keep_event_probabilities = FALSE,
  censored_types = NULL,
  ...
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{data}{A \code{data.frame}.  Data of nodes that can take three values:
0, 1, and NA. In long form as generated by \code{\link{make_events}}}

\item{data_type}{Either 'long' (as made by \code{\link{make_data}}) or
'compact' (as made by \code{\link{collapse_data}}). Compact data must
have entries for each member of each strategy family to produce a
valid simplex. When long form data is provided with missingness, missing
data is assumed to be missing at random.}

\item{keep_fit}{Logical. Whether to append the
\link[rstan]{stanfit} object to the model. Defaults to `FALSE`. See
\code{`?rstan::stanfit`} for details of output.}

\item{keep_transformed}{Logical. Whether to keep transformed parameters,
prob_of_types, P_lambdas, w, w_full}

\item{keep_event_probabilities}{Logical. Whether to keep the distribution
of event probabilities. Defaults to `FALSE`}

\item{censored_types}{vector of data types that are selected out of
the data, e.g. \code{c("X0Y0")}}

\item{...}{Options passed onto \link[rstan]{sampling} call. For
details see \code{?rstan::sampling}}
}
\value{
An object of class \code{causal_model}. The returned model is a
  list containing the elements comprising a model
  (e.g. 'statement', 'nodal_types' and 'DAG') with the
  \code{posterior_distribution} returned by \link[rstan]{stan}
  attached to it.
}
\description{
Takes a model and data and returns a model object with data
attached and a posterior model
}
\examples{
model <- make_model('X->Y')
data_long   <- simulate_data(model, n = 4)
data_short  <- collapse_data(data_long, model)
\donttest{
model_1 <- update_model(model, data_long)
}
\donttest{
model_2 <- update_model(model, data_long, keep_transformed = FALSE)
}
\dontrun{
# Throws error unless compact data indicated:

model_3 <- update_model(model, data_short)
model_4 <- update_model(model, data_short, data_type = 'compact')

# It is possible to implement updating without data, in which
# case the posterior is a stan object that reflects the prior
model_5 <- update_model(model)


# Censored data types
# We update less than we might because we are aware of filtered data
uncensored <-  make_model("X->Y") \%>\%
  update_model(data.frame(X=rep(0:1, 10), Y=rep(0:1,10))) |>
  query_model(te("X", "Y"), using = "posteriors")

censored <- make_model("X->Y") \%>\%
  update_model(data.frame(X=rep(0:1, 10), Y=rep(0:1,10)),
  censored_types = c("X1Y0")) \%>\%
  query_model(te("X", "Y"), using = "posteriors")

# Censored data: We learning nothing because the data
# we see is the only data we could ever see
make_model("X->Y") \%>\%
  update_model(data.frame(X=rep(1,5), Y=rep(1,5)),
  censored_types = c("X1Y0", "X0Y0", "X0Y1")) \%>\%
  query_model(te("X", "Y"), using = "posteriors")
}
}
