% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_restrictions.R
\name{restrict_by_labels}
\alias{restrict_by_labels}
\title{Reduce nodal types using labels}
\usage{
restrict_by_labels(
  model,
  labels,
  given = NULL,
  keep = FALSE,
  update_types = TRUE,
  wildcard = FALSE
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{labels}{A list of character vectors specifying nodal types to be kept or removed from the model.}

\item{given}{A character vector or list of character vectors specifying nodes on which the parameter set to be restricted depends. When mixing labels that are further restricted by \code{given} and ones that are not, labels without \code{given} restrictions should have \code{given} specified as one of \code{NULL}, \code{NA}, \code{""} or \code{" "}.}

\item{keep}{Logical. If `FALSE`, removes and if `TRUE` keeps only causal types specified by \code{restriction}.}
}
\value{
An object of class \code{causal_model}. The causal types and nodal types in the model are reduced according to the stated restriction.
}
\description{
Reduce nodal types using labels
}
\seealso{
Other restrictions: 
\code{\link{restrict_by_query}()},
\code{\link{set_restrictions}()}
}
\concept{restrictions}
\keyword{internal}
