% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.data.targetmodel.R
\name{generate.data.targetmodel}
\alias{generate.data.targetmodel}
\title{Target model based on predictor trajectories}
\usage{
generate.data.targetmodel(env = rep(1, 10), noise.sd = 0.01, L = 15,
  d = 7, seed = NA)
}
\arguments{
\item{env}{integer vector of length n encoding to which experiment
each repetition belongs.}

\item{noise.sd}{numerical value specifying the standard deviation
of the noise.}

\item{L}{number of time points for evaluation.}

\item{d}{number of total variables (d-1 preditor variables).}

\item{seed}{random seed. Does not work if a "Detected blow-up"
warning shows up.}
}
\value{
list consisting of the following elements

\item{simulated.data}{D-matrix of noisy data.}
\item{time}{vector containing time points}
\item{env}{vector specifying the experimental environment.}
\item{true.model}{vector specifying the target equation model.}
\item{target}{target variable.}
}
\description{
Generate sample data from the target model based on predictor trajectories.
}
\details{
For further details see the references.
}
\examples{

simulation.obj <- generate.data.targetmodel(env=rep(1:5, 3),
                                            L=15,
                                            d=5)

D <- simulation.obj$simulated.data
fulldata <- simulation.obj$simulated.model
time <- simulation.obj$time
plot(time, D[1,1:length(time)], col="red", pch=19)
legend("topright", c("observations"),
       col=c("red"), pch=c(19))
}
\references{
Pfister, N., S. Bauer, J. Peters (2018).
Identifying Causal Structure in Large-Scale Kinetic Systems
ArXiv e-prints (arXiv:1810.11776).
}
\seealso{
The functions \code{\link{generate.data.maillard}} and
  \code{\link{generate.data.hidden}} allow to simulate ODE data
  from two additional models.
}
\author{
Niklas Pfister, Stefan Bauer and Jonas Peters
}
