% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conic_solvers.R
\docType{class}
\name{ECOS_BB-class}
\alias{ECOS_BB-class}
\alias{ECOS_BB}
\alias{mip_capable,ECOS_BB-method}
\alias{name,ECOS_BB-method}
\alias{perform,ECOS_BB,Problem-method}
\alias{solve_via_data,ECOS_BB-method}
\title{An interface for the ECOS BB solver.}
\usage{
ECOS_BB()

\S4method{mip_capable}{ECOS_BB}(solver)

\S4method{name}{ECOS_BB}(x)

\S4method{perform}{ECOS_BB,Problem}(object, problem)

\S4method{solve_via_data}{ECOS_BB}(
  object,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts,
  solver_cache = list()
)
}
\arguments{
\item{solver, object, x}{A \linkS4class{ECOS_BB} object.}

\item{problem}{A \linkS4class{Problem} object.}

\item{data}{Data generated via an apply call.}

\item{warm_start}{A boolean of whether to warm start the solver.}

\item{verbose}{A boolean of whether to enable solver verbosity.}

\item{feastol}{The feasible tolerance.}

\item{reltol}{The relative tolerance.}

\item{abstol}{The absolute tolerance.}

\item{num_iter}{The maximum number of iterations.}

\item{solver_opts}{A list of Solver specific options}

\item{solver_cache}{Cache for the solver.}
}
\description{
An interface for the ECOS BB solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{mip_capable}: Can the solver handle mixed-integer programs?

\item \code{name}: Returns the name of the solver.

\item \code{perform}: Returns a new problem and data for inverting the new solution.

\item \code{solve_via_data}: Solve a problem represented by data returned from apply.
}}

