% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conic_solvers.R
\docType{class}
\name{GUROBI_CONIC-class}
\alias{GUROBI_CONIC-class}
\alias{GUROBI_CONIC}
\alias{mip_capable,GUROBI_CONIC-method}
\alias{name,GUROBI_CONIC-method}
\alias{import_solver,GUROBI_CONIC-method}
\alias{status_map,GUROBI_CONIC-method}
\alias{accepts,GUROBI_CONIC,Problem-method}
\alias{perform,GUROBI_CONIC,Problem-method}
\alias{invert,GUROBI_CONIC,list,list-method}
\alias{solve_via_data,GUROBI_CONIC-method}
\title{An interface for the GUROBI conic solver.}
\usage{
GUROBI_CONIC()

\S4method{mip_capable}{GUROBI_CONIC}(solver)

\S4method{name}{GUROBI_CONIC}(x)

\S4method{import_solver}{GUROBI_CONIC}(solver)

\S4method{status_map}{GUROBI_CONIC}(solver, status)

\S4method{accepts}{GUROBI_CONIC,Problem}(object, problem)

\S4method{perform}{GUROBI_CONIC,Problem}(object, problem)

\S4method{invert}{GUROBI_CONIC,list,list}(object, solution, inverse_data)

\S4method{solve_via_data}{GUROBI_CONIC}(
  object,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts,
  solver_cache
)
}
\arguments{
\item{solver, object, x}{A \linkS4class{GUROBI_CONIC} object.}

\item{status}{A status code returned by the solver.}

\item{problem}{A \linkS4class{Problem} object.}

\item{solution}{The raw solution returned by the solver.}

\item{inverse_data}{A list containing data necessary for the inversion.}

\item{data}{Data generated via an apply call.}

\item{warm_start}{A boolean of whether to warm start the solver.}

\item{verbose}{A boolean of whether to enable solver verbosity.}

\item{feastol}{The feasible tolerance.}

\item{reltol}{The relative tolerance.}

\item{abstol}{The absolute tolerance.}

\item{num_iter}{The maximum number of iterations.}

\item{solver_opts}{A list of Solver specific options}

\item{solver_cache}{Cache for the solver.}
}
\description{
An interface for the GUROBI conic solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{mip_capable(GUROBI_CONIC)}: Can the solver handle mixed-integer programs?

\item \code{name(GUROBI_CONIC)}: Returns the name of the solver.

\item \code{import_solver(GUROBI_CONIC)}: Imports the solver.

\item \code{status_map(GUROBI_CONIC)}: Converts status returned by the GUROBI solver to its respective CVXPY status.

\item \code{accepts(object = GUROBI_CONIC, problem = Problem)}: Can GUROBI_CONIC solve the problem?

\item \code{perform(object = GUROBI_CONIC, problem = Problem)}: Returns a new problem and data for inverting the new solution.

\item \code{invert(object = GUROBI_CONIC, solution = list, inverse_data = list)}: Returns the solution to the original problem given the inverse_data.

\item \code{solve_via_data(GUROBI_CONIC)}: Solve a problem represented by data returned from apply.

}}
