% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{Solver-capable}
\alias{Solver-capable}
\alias{lp_capable}
\alias{socp_capable}
\alias{sdp_capable}
\alias{exp_capable}
\alias{mip_capable}
\title{Solver Capabilities}
\usage{
lp_capable(solver)

socp_capable(solver)

sdp_capable(solver)

exp_capable(solver)

mip_capable(solver)
}
\arguments{
\item{solver}{A \linkS4class{Solver} object.}
}
\value{
A logical value.
}
\description{
Determine if a solver is capable of solving a linear program (LP), second-order cone program (SOCP), semidefinite program (SDP), exponential cone program (EXP), or mixed-integer program (MIP).
}
\examples{
lp_capable(ECOS())
socp_capable(ECOS())
sdp_capable(ECOS())
exp_capable(ECOS())
mip_capable(ECOS())
}
