% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\docType{class}
\name{SOC-class}
\alias{SOC-class}
\alias{.SOC}
\alias{SOC}
\alias{as.character,SOC-method}
\alias{format_constr,SOC-method}
\alias{size,SOC-method}
\title{The SOC class.}
\usage{
SOC(t, x_elems)

\S4method{as.character}{SOC}(x)

\S4method{format_constr}{SOC}(object, eq_constr, leq_constr, dims, solver)

\S4method{size}{SOC}(object)
}
\arguments{
\item{t}{The scalar part of the second-order constraint.}

\item{x_elems}{A list containing the elements of the vector part of the constraint.}

\item{x, object}{A \linkS4class{SOC} object.}

\item{eq_constr}{A list of the equality constraints in the canonical problem.}

\item{leq_constr}{A list of the inequality constraints in the canonical problem.}

\item{dims}{A list with the dimensions of the conic constraints.}

\item{solver}{A string representing the solver to be called.}
}
\description{
This class represents a second-order cone constraint, i.e. \eqn{\|x\|_2 \leq t}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{format_constr}: Format SOC constraints as inequalities for the solver.

\item \code{size}: The dimensions of the second-order cone.
}}

\section{Slots}{

\describe{
\item{\code{constr_id}}{(Internal) A unique integer identification number used internally.}

\item{\code{t}}{The scalar part of the second-order constraint.}

\item{\code{x_elems}}{A list containing the elements of the vector part of the constraint.}
}}

