% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\docType{class}
\name{SDP-class}
\alias{SDP-class}
\alias{.SDP}
\alias{SDP}
\alias{SDP}
\alias{as.character,SDP-method}
\alias{size,SDP-method}
\alias{format_constr,SDP-method}
\title{The SDP class.}
\usage{
SDP(A, enforce_sym = TRUE, constr_id)

\S4method{as.character}{SDP}(x)

\S4method{size}{SDP}(object)

\S4method{format_constr}{SDP}(object, eq_constr, leq_constr, dims, solver)
}
\arguments{
\item{A}{The matrix variable constrained to be semidefinite.}

\item{enforce_sym}{A logical value indicating whether symmetry constraints should be added.}

\item{constr_id}{(Internal) A unique integer identification number used internally.}

\item{x, object}{A \linkS4class{SDP} object.}

\item{eq_constr}{A list of the equality constraints in the canonical problem.}

\item{leq_constr}{A list of the inequality constraints in the canonical problem.}

\item{dims}{A list with the dimensions of the conic constraints.}

\item{solver}{A string representing the solver to be called.}
}
\description{
This class represents a semidefinite cone constraint, the set of all symmetric matrices such that the quadratic form \eqn{x^TAx} is non-negative for all \eqn{x}.
\deqn{
\{\mbox{symmetric } A | x^TAx \geq 0 \mbox{ for all } x\}
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{size}: The dimensions of the semidefinite cone.

\item \code{format_constr}: Format SDP constraints as inequalities for the solver.
}}

\section{Slots}{

\describe{
\item{\code{constr_id}}{(Internal) A unique integer identification number used internally.}

\item{\code{A}}{The matrix variable constrained to be semidefinite.}

\item{\code{enforce_sym}}{A logical value indicating whether symmetry constraints should be added.}
}}

