% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble.R
\name{ensemble_exp}
\alias{ensemble_exp}
\title{Estimating Ensemble Kernel Matrices Using EXP}
\usage{
ensemble_exp(beta_exp, error_mat, A_hat)
}
\arguments{
\item{beta_exp}{(numeric/character) A numeric value specifying the parameter
when strategy = "exp". See Details.}

\item{error_mat}{(matrix, n*K) A n\*K matrix indicating errors.}

\item{A_hat}{(list of length K) A list of projection matrices to kernel space 
for each kernel in the kernel library.}
}
\value{
\item{A_est}{(matrix, n*n) The ensemble projection matrix.}

\item{u_hat}{(vector of length K) A vector of weights of the kernels in the
library.}
}
\description{
Give the ensemble projection matrix and weights of the kernels in the
library using exponential weighting.
}
\details{
\bold{Exponential Weighting}

Additionally, another scholar gives a new strategy to calculate weights
based on the estimated errors \eqn{\{\hat{\epsilon}_d\}_{d=1}^D}.
\deqn{u_d(\beta)=\frac{exp(-\parallel \hat{\epsilon}_d
\parallel_2^2/\beta)}{\sum_{d=1}^Dexp(-\parallel \hat{\epsilon}_d
\parallel_2^2/\beta)}}

\bold{beta_exp}

The value of beta_exp can be "min"=\eqn{min\{RSS\}_{d=1}^D/10},
"med"=\eqn{median\{RSS\}_{d=1}^D}, "max"=\eqn{max\{RSS\}_{d=1}^D*2} and any
other positive numeric number, where \eqn{\{RSS\} _{d=1}^D} are the set of
residual sum of squares of \eqn{D} base kernels.
}
\references{
Jeremiah Zhe Liu and Brent Coull. Robust Hypothesis Test for
Nonlinear Effect with Gaussian Processes. October 2017.

Xiang Zhan, Anna Plantinga, Ni Zhao, and Michael C. Wu. A fast small-sample
kernel inde- pendence test for microbiome community-level association
analysis. December 2017.

Arnak S. Dalalyan and Alexandre B. Tsybakov. Aggregation by Exponential
Weighting and Sharp Oracle Inequalities. In Learning Theory, Lecture Notes
in Computer Science, pages 97– 111. Springer, Berlin, Heidelberg, June 2007.
}
\seealso{
mode: \code{\link{tuning}}
}
\author{
Wenying Deng
}
