% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube000.R
\name{cube000}
\alias{cube000}
\title{Main function for CUBE models without covariates}
\usage{
cube000(m, ordinal, starting, maxiter, toler, expinform)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{starting}{Vector of initial estimates to start the optimization algorithm, 
whose length equals the number of parameters of the model}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}

\item{expinform}{Logical: if TRUE, the function returns the expected variance-covariance matrix}
}
\value{
An object of the class "CUBE"
}
\description{
Estimate and validate a CUBE model without covariates.
}
\examples{
### Applying donttest option since the proposed examples require long time run for check 
\donttest{
data(relgoods)
m=10
ordinal=na.omit(relgoods[,37])
starting = rep(0.1, 3)                              
fitcube=cube000(m, ordinal, starting, maxiter=500, toler=1e-6, makeplot=TRUE, expinform=FALSE,
        summary=T)
param=fitcube$estimates
pai=param[1]           # ML estimate for the uncertainty parameter
csi=param[2]           # ML estimate for the feeling parameter
phi=param[3]           # ML estimate for the overdispersion parameter
maxlik=fitcube$loglik 
niter=fitcube$niter
BIC=fitcube$BIC
###################
data(univer)
m=7
ordinal=univer[,8]
starting=inibestcube(m,ordinal)    
model=cube000(m,ordinal,starting,maxiter=200,toler=1e-4,makeplot=TRUE,expinform=TRUE,summary=F)
param=model$estimates   # Final ML estimates (pai,csi,phi)
maxlik=model$loglik
model$varmat
model$niter
model$BIC
}
}
\references{
Iannario, M. (2014). Modelling Uncertainty and Overdispersion in Ordinal Data,
  \emph{Communications in Statistics - Theory and Methods}, \bold{43}, 771--786 \cr
Iannario, M. (2015). Detecting latent components in ordinal data with overdispersion by means 
of a mixture distribution, \emph{Quality & Quantity}, \bold{49}, 977--987
}
\keyword{#models}
\keyword{internal}
