% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cste_surv_PCI.R
\name{cste_surv_PCI}
\alias{cste_surv_PCI}
\title{Calculate pointwise confidence intervals of CSTE curve for time to event outcome with right censoring.}
\usage{
cste_surv_PCI(fit, alpha = 0.05)
}
\arguments{
\item{fit}{a S3 class of cste.}

\item{alpha}{the pointwise confidence intervals are of \eqn{1-\alpha} confidence level.}
}
\value{
A list which includes:
\itemize{
   \item \code{or_x}: the ordered value of \eqn{X\beta_1}. 
   \item \code{fit_x}: the fitted value of CSTE curve corresponding to \code{or_x}.
   \item \code{lower_bound}: the lower bound of CSTE's pointwise confidence intervals.
   \item \code{upper_bound}: the upper bound of CSTE's pointwise confidence intervals.
}
}
\description{
This function calculates pointwise confidence intervals of CSTE curve for time to event outcome with right censoring.
}
\references{
Ma Y. and Zhou X. (2017). 
Treatment selection in a randomized clinical trial via covariate-specific 
treatment effect curves, \emph{Statistical Methods in Medical Research}, 26(1), 124-141.
}
\seealso{
\code{\link{cste_surv}}
}
