% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectPeriodOnData.R
\name{SelectPeriodOnData}
\alias{SelectPeriodOnData}
\title{Select a period on Data on multidimensional array objects}
\usage{
SelectPeriodOnData(data, dates, start, end, time_dim = "ftime", ncores = NULL)
}
\arguments{
\item{data}{A multidimensional array with named dimensions with at least the
time dimension specified in parameter 'time_dim'. All common dimensions
with 'dates' parameter need to have the same length.}

\item{dates}{An array of dates with named dimensions with at least the time 
dimension specified in parameter 'time_dim'. All common dimensions with
'data' parameter need to have the same length.}

\item{start}{A list with two elements to define the initial date of the period 
to select from the data. The first element is the initial day of the period 
and the second element is the initial month of the period.}

\item{end}{A list with two elements to define the final date of the period 
to select from the data. The first element is the final day of the period 
and the second element is the final month of the period.}

\item{time_dim}{A character string indicating the name of the dimension to 
compute select the dates. By default, it is set to 'ftime'. Parameters 
'data' and 'dates'}

\item{ncores}{An integer indicating the number of cores to use in parallel 
computation.}
}
\value{
A multidimensional array with named dimensions containing the subset 
of the object \code{data} during the period requested from \code{start} to 
\code{end}.
}
\description{
Auxiliary function to subset data for a specific period.
}
\examples{
data <- array(rnorm(5 * 3 * 214 * 2),
             c(memb = 5, sdate = 3, ftime = 214, lon = 2)) 
Dates <- c(seq(as.Date("01-05-2000", format = "\%d-\%m-\%Y"), 
              as.Date("30-11-2000", format = "\%d-\%m-\%Y"), by = 'day'),
          seq(as.Date("01-05-2001", format = "\%d-\%m-\%Y"), 
              as.Date("30-11-2001", format = "\%d-\%m-\%Y"), by = 'day'),
          seq(as.Date("01-05-2002", format = "\%d-\%m-\%Y"), 
              as.Date("30-11-2002", format = "\%d-\%m-\%Y"), by = 'day'))
dim(Dates) <- c(ftime = 214, sdate = 3)
Period <- SelectPeriodOnData(data, Dates, start = list(21, 6), end = list(21, 9))
}
