% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindPowerDensity.R
\name{CST_WindPowerDensity}
\alias{CST_WindPowerDensity}
\title{Wind power density on s2dv_cube objects}
\usage{
CST_WindPowerDensity(
  wind,
  ro = 1.225,
  start = NULL,
  end = NULL,
  time_dim = "ftime",
  ncores = NULL
)
}
\arguments{
\item{wind}{a s2dv_cube object with instantaneous wind speeds expressed in m/s obtained from CST_Load or s2dv_cube functions from CSTools pacakge}

\item{ro}{a scalar, or alternatively a multidimensional array with the same dimensions as wind, with the air density expressed in kg/m^3. By default it takes the value 1.225, the standard density of air at 15ºC and 1013.25 hPa.}

\item{start}{an optional parameter to defined the initial date of the period to select from the data by providing a list of two elements: the initial date of the period and the initial month of the period. By default it is set to NULL and the indicator is computed using all the data provided in \code{data}.}

\item{end}{an optional parameter to defined the final date of the period to select from the data by providing a list of two elements: the final day of the period and the final month of the period. By default it is set to NULL and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{a character string indicating the name of the function to compute the indicator. By default, it is set to 'ftime'. More than one dimension name matching the dimensions provided in the object \code{data$data} can be specified.}

\item{ncores}{an integer indicating the number of cores to use in parallel computation for temporal subsetting.}
}
\value{
A s2dv_cube object containing Wind Power Density expressed in W/m^2.
}
\description{
Wind Power Density computes the wind power that is available for extraction per square meter of swept area.

It is computed as 0.5*ro*wspd^3. As this function is non-linear, it will give inaccurate results if used with period means.
}
\examples{
wind <- array(rweibull(n = 100, shape = 2, scale = 6), c(member = 10, lat = 2, lon = 5))
wind <- CSTools::s2dv_cube(data = wind, lat = c(40, 41), lon = 1:5,
                 Variable = list(varName = 'sfcWind', level = 'Surface'), 
                 Datasets = 'synthetic', when = Sys.time(),
                 Dates = list(start = '1990-01-01 00:00:00', end = '1990-01-01 00:00:00'),
                 source_file = NA)
WPD <- CST_WindPowerDensity(wind)

}
\author{
Llorenç Lledó, \email{llledo@bsc.es}
}
