% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_read_AHCCD_daily.R
\name{ch_read_AHCCD_daily}
\alias{ch_read_AHCCD_daily}
\title{Reads AHCCD daily file}
\usage{
ch_read_AHCCD_daily(daily_file)
}
\arguments{
\item{daily_file}{Required. Name of the file to be read.}
}
\value{
If successful, returns the values in a data frame, consisting of the date, 
the value and the data code.
}
\description{
This program reads an Adjusted and Homogenized Canadian Climate Data (AHCCD) of daily 
precipitation or temperatures. The values are arranged as
month x day, which makes them difficult to read using standard \R functions.
}
\examples{
\dontrun{
# Don't run this example as it requires a file, and use of the dummy
# file will cause an error message

stoon_daily_tmax <- ch_read_AHCCD_daily("dx40657120.txt")}
}
\references{
Daily AHCCD data are available from \url{http://crd-data-donnees-rdc.ec.gc.ca/CDAS/products/EC_data/AHCCD_daily/}. 
Any use of the data must cite 
\cite{Mekis, E and L.A. Vincent, 2011: An overview of the second generation 
adjusted daily precipitation dataset for trend analysis in Canada. 
Atmosphere-Ocean, 49 (2), 163-177.}
}
\seealso{
\code{\link{ch_read_AHCCD_monthly}}
}
\author{
Kevin Shook
}
