% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_doys.R
\name{ch_doys}
\alias{ch_doys}
\title{Days of year and water year}
\usage{
ch_doys(Date, water_yr = 10)
}
\arguments{
\item{Date}{an array of \R dates, as produced by \code{as.Date()}}

\item{water_yr}{the month starting the water year, default is 10 (October). If
a value of \code{1} is specified, the \code{10} will be used.}
}
\value{
Returns a dataframe with date information:
\item{Date}{in Date format}
\item{year}{numeric calendar year}
\item{month}{number calendar month}
\item{doy}{numeric day of year}
\item{wyear}{numeric water year starting on day 1 of selected month}
\item{dwy}{numeric day of water year}
}
\description{
Converts an array of dates into a dataframe with date, year, month, doy,
wyear, dowy. 

The day of water year is computed from the first of the specified water year month.
}
\details{
Converts a date array into a data frame with years, wateryears, and days of year and of water year.
}
\examples{
dd <- seq.Date(as.Date("2010-01-01"), as.Date("2018-01-01"),by = 1)
output <- ch_doys(dd, water_yr=10)
head(output)

}
\author{
Paul Whitfield, Kevin Shook
}
