% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{decode.icm}
\alias{decode.icm}
\title{Decoding method using iterated conditional modes algorithm}
\usage{
decode.icm(crf, restart = 0, start = apply(crf$node.pot, 1, which.max))
}
\arguments{
\item{crf}{The CRF}

\item{restart}{Non-negative integer to control how many restart iterations are repeated}

\item{start}{An initial configuration, a good start will significantly reduce the seraching time}
}
\value{
This function will return the most likely configuration, which is a vector of length \code{crf$n.nodes}.
}
\description{
Computing the most likely configuration for CRF
}
\details{
Approximate decoding with the iterated conditional modes algorithm
}
\examples{

library(CRF)
data(Small)
d <- decode.icm(Small$crf)

}
