% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProxGrad_Coefficient_Functions.R
\name{coef.cv.ProxGrad}
\alias{coef.cv.ProxGrad}
\title{Coefficients for cv.ProxGrad Object}
\usage{
\method{coef}{cv.ProxGrad}(object, ...)
}
\arguments{
\item{object}{An object of class cv.ProxGrad.}

\item{...}{Additional arguments for compatibility.}
}
\value{
The coefficients for the cv.ProxGrad object.
}
\description{
\code{coef.cv.ProxGrad} returns the coefficients for a cv.ProxGrad object.
}
\examples{
\donttest{
# Data simulation
set.seed(1)
n <- 50
N <- 2000
p <- 1000
beta.active <- c(abs(runif(p, 0, 1/2))*(-1)^rbinom(p, 1, 0.3))
# Parameters
p.active <- 100
beta <- c(beta.active[1:p.active], rep(0, p-p.active))
Sigma <- matrix(0, p, p)
Sigma[1:p.active, 1:p.active] <- 0.5
diag(Sigma) <- 1

# Train data
x.train <- mvnfast::rmvn(n, mu = rep(0, p), sigma = Sigma) 
prob.train <- exp(x.train \%*\% beta)/
              (1+exp(x.train \%*\% beta))
y.train <- rbinom(n, 1, prob.train)
# Test data
x.test <- mvnfast::rmvn(N, mu = rep(0, p), sigma = Sigma)
prob.test <- exp(x.test \%*\% beta)/
             (1+exp(x.test \%*\% beta))
y.test <- rbinom(N, 1, prob.test)

# CV ProxGrad - Single Group
proxgrad.out <- cv.ProxGrad(x.train, y.train,
                            glm_type = "Logistic",
                            include_intercept = TRUE,
                            alpha_s = 3/4,
                            n_lambda_sparsity = 100, 
                            acceleration = TRUE,
                            tolerance = 1e-5, max_iter = 1e5)

# Coefficients
coef(proxgrad.out)

}

}
\seealso{
\code{\link{cv.ProxGrad}}
}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
