% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em_function_2stage.R
\name{em_function_2stage}
\alias{em_function_2stage}
\title{EM-Algorithm Function for Estimation of the Two-Stage Misclassification Model}
\usage{
em_function_2stage(
  param_current,
  obs_Ystar_matrix,
  obs_Ytilde_matrix,
  X,
  Z,
  V,
  sample_size,
  n_cat
)
}
\arguments{
\item{param_current}{A numeric vector of regression parameters, in the order
\eqn{\beta, \gamma, \delta}. The \eqn{\gamma} vector is obtained from the matrix form.
In matrix form, the gamma parameter matrix rows
correspond to parameters for the \code{Y* = 1}
observed outcome, with the dimensions of \code{Z}.
In matrix form, the gamma parameter matrix columns correspond to the true outcome categories
\eqn{j = 1, \dots,} \code{n_cat}. The numeric vector \eqn{\gamma} is
obtained by concatenating the gamma matrix, i.e. \code{gamma_v <- c(gamma_matrix)}.
The \eqn{\delta} vector is obtained from the array form. In array form,
the first dimension (matrix rows) of \code{delta}
corresponds to parameters for the \eqn{\tilde{Y} = 1}
second-stage observed outcome, with the dimensions of the \code{V}
The second dimension (matrix columns) correspond to the first-stage
observed outcome categories \eqn{Y^* \in \{1, 2\}}. The third dimension of
\code{delta_start} corresponds to to the true outcome categories
\eqn{Y \in \{1, 2\}}. The numeric vector \eqn{\delta} is obtained by
concatenating the delta array, i.e. \code{delta_vector <- c(delta_array)}.}

\item{obs_Ystar_matrix}{A numeric matrix of indicator variables (0, 1) for the first-stage observed
outcome \code{Y*}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row should contain
exactly one 0 entry and exactly one 1 entry.}

\item{obs_Ytilde_matrix}{A numeric matrix of indicator variables (0, 1) for the second-stage observed
outcome \eqn{\tilde{Y}}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row should contain
exactly one 0 entry and exactly one 1 entry.}

\item{X}{A numeric design matrix for the true outcome mechanism.}

\item{Z}{A numeric design matrix for the first-stage observation mechanism.}

\item{V}{A numeric design matrix for the second-stage observation mechanism.}

\item{sample_size}{An integer value specifying the number of observations in the sample.
This value should be equal to the number of rows of the design matrices, \code{X}, \code{Z}, and \code{V}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{Y},
and the observed outcomes, \code{Y*} and \eqn{\tilde{Y}}, can take.}
}
\value{
\code{em_function_2stage} returns a numeric vector of updated parameter
estimates from one iteration of the EM-algorithm.
}
\description{
EM-Algorithm Function for Estimation of the Two-Stage Misclassification Model
}
