% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{extractReplicateValues}
\alias{extractReplicateValues}
\title{On basis of input well ranges, the function extracts values of these ranges from data.}
\usage{
extractReplicateValues(rawDataUnProcessed, wellRanges, wellplace = 3,
  simple = FALSE, excelFormate = FALSE)
}
\arguments{
\item{rawDataUnProcessed}{A data matrix.}

\item{wellRanges}{Ranges of wells.}

\item{wellplace}{Place of treated (case) well range.}

\item{simple}{TRUE if survival values are already calculated otherwise it is FALSE.}

\item{excelFormate}{True if well ranges are in excel format.}
}
\value{
Replicate values.
}
\description{
On basis of input well ranges, the function extracts values of these ranges from data.
}
\examples{
dataFile <- system.file("/raw/testData.xls", package="COMBIA")
rData <- read.xls( dataFile, sheet=1, skip=0, sep=",", nrows=41,
                    fill=TRUE, header=FALSE,
                    blank.lines.skip = FALSE)[,1:13]
wellR= c( "l3:l10","m3:m10","b3:k10",  "l13:l20","m13:m20","b13:k20",
            "l23:l30","m23:m30","b23:k30",  "l33:l40","m33:m40","b33:k40")
rslt <-  extractReplicateValues(rData, wellR, excelFormate=TRUE )
}
\author{
Muhammad kashif
}

