% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{selectPlate}
\alias{selectPlate}
\title{Select one readout from the twice read data and store selected values.
In those cases where an experiment is read twice, only one readout from each pair is selected.
The selection is based on presence of minimum number of "selection key" or read with
highest mean is picked in case of tie.}
\usage{
selectPlate(rawdata, processedbarcode, numberofrowsperplate, selectionkey,
  doubleplateexperiment)
}
\arguments{
\item{rawdata}{An object (dataframe) of rawdata.}

\item{processedbarcode}{A vector containing all barcodes of data. In this case it is the output of function "extractKey".}

\item{numberofrowsperplate}{This argument is not needed when you call function "readFluostarPlates".
The number of rows depends upon the geometry of the plates. These are 16 in case of 384 well plates.}

\item{selectionkey}{key Value, that is used to select one of double read outs.}

\item{doubleplateexperiment}{This parameter value can either be TRUE or FALSE. It is TRUE when an experiment is read twice.}
}
\value{
A hash table of selected readouts. Note: Hash tables are used to store the FMCA data because it consists of a key
(barcode) and a corresponding data. If COMBIA is used for large amount of FMCA data then the data in the hash table will
be more transparent, logical and easy to access than matrices.
}
\description{
Select one readout from the twice read data and store selected values.
In those cases where an experiment is read twice, only one readout from each pair is selected.
The selection is based on presence of minimum number of "selection key" or read with
highest mean is picked in case of tie.
}
\examples{
f <- system.file("/raw/optima.log", package="COMBIA")
fileDF <- readFile(filename = f, separator = ",", noofrows_skip=0,
                   platetype="384")
Generatedbarcode <-  extractKey(keyposition = 2,
    rawdata = fileDF, numberofrowsperplate = 17, doubleplateexperiment=TRUE)
hashedplates <-  selectPlate(rawdata=fileDF,
    processedbarcode = Generatedbarcode, numberofrowsperplate=17,
    selectionkey="65000", doubleplateexperiment = FALSE )
}
\author{
Muhammad Kashif
}

