% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{n_goalposts}
\alias{n_goalposts}
\title{Normalise using goalpost method}
\usage{
n_goalposts(x, gposts, direction = 1, trunc2posts = TRUE)
}
\arguments{
\item{x}{A numeric vector}

\item{gposts}{A numeric vector \code{c(l, u, a)}, where \code{l} is the lower bound, \code{u} is the upper bound,
and \code{a} is a scaling parameter.}

\item{direction}{Either 1 or -1. Set to -1 to flip goalposts.}

\item{trunc2posts}{If \code{TRUE} (default) will truncate any values that fall outside of the goalposts.}
}
\value{
Numeric vector
}
\description{
The distance of each value of \code{x} from the lower "goalpost" to the upper one. Goalposts are specified by
\code{gposts = c(l, u, a)}, where \code{l} is the lower bound, \code{u} is the upper bound, and \code{a} is a scaling parameter.
}
\details{
Specify \code{direction = -1} to "flip" the goalposts. This may be necessary depending on how the goalposts
were defined.
}
\examples{
x <- runif(20)
n_goalposts(x, gposts = c(0.2, 0.8, 1))

}
