% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_iplot.R
\name{iplotIndDist2}
\alias{iplotIndDist2}
\title{Interactive indicator distribution plots for two indicators simultaneously}
\usage{
iplotIndDist2(
  COIN,
  dsets = "Raw",
  icodes = NULL,
  ptype = "Scatter",
  aglevs = 1
)
}
\arguments{
\item{COIN}{The COIN, or a data frame of indicator data}

\item{dsets}{The source data sets to use for indicator data (if input is COIN object). If the source
data sets are the same, this can be a single character string, otherwise, a character vector, e.g.
\code{c("Raw", "Treated")}.}

\item{icodes}{A character vector of two indicator codes to plot (corresponding to the two \code{dset}s specified)}

\item{ptype}{The type of plot to produce. Currently supports \code{"Histogram"} and \code{"Scatter"}.}

\item{aglevs}{The aggregation level to extract the indicator data from. Defaults to indicator level (1). This also can
be specified as a vector if the two indicators are from different levels.}
}
\value{
Plots generated with \strong{plotly}. These can be edited further with \strong{plotly} commands.
}
\description{
Generates a JavaScript distribution plot of two indicators, using Plotly. Plot can be embedded e.g. in
HTML documents, websites, etc, or used for more interactive data exploration.
}
\examples{
# build ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# plot CO2 against renewable energy indicator
iplotIndDist2(ASEM, dsets = "Raw", icodes = c("Renew", "CO2"))

}
