% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsample_genomic_matrix.R
\name{downsample_genomic_matrix}
\alias{downsample_genomic_matrix}
\title{Rescale positive and negative data, preserving sign information.}
\arguments{
\item{whole_matrix}{A matrix to be downsampled, on a single chromosome}

\item{downsamplefactor}{A factor by which to reduce the matrix. Must be something that both the row and columns can be divisible by.}

\item{singlechromosome}{Single chromosome mode; Multi-chromosome not yet implemented (leave T)}
}
\value{
whole_matrix_dsamp A downsampled matrix.
}
\description{
Downsamples a matrix by a specified factor.
}
\examples{
load(system.file("extdata","nbl_result_matrix_sign_small.rda",package = "CNVScope"))
downsample_genomic_matrix(whole_matrix=nbl_result_matrix_sign_small,
downsamplefactor=5,singlechromosome=TRUE)
}
\keyword{matrix}
\keyword{negative}
\keyword{positive}
\keyword{rescale}
\keyword{signed}
