% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_switchgear_primary_10kv.R
\name{environmental_cof_switchgear_primary_10kv}
\alias{environmental_cof_switchgear_primary_10kv}
\title{Environmental cost of Failure for 10kV Switchgear Primary}
\usage{
environmental_cof_switchgear_primary_10kv(type_env_factor, prox_water, bunded)
}
\arguments{
\item{type_env_factor}{String The type environment factor of HV asset category
Options: \code{type_env_factor = c("Oil", "SF6", "Niether", "Default")}.}

\item{prox_water}{Numeric. Specify the proximity to a water course in meters.
A setting of \code{"Default"} will result in a proximity factor of 1. Thus
assume the proximity to a water course is between 80m and 120m}

\item{bunded}{String. Options: \code{bunded = c("Yes", "No", "Default")}.
A setting of \code{"Default"} will result in a bunding factor of 1.}
}
\value{
Numeric. Financial consequences of failure for 10kV switchgear
}
\description{
This function calculates environmental consequences of failure
Environmental consequences of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
Outputted in DKK.
}
\examples{
environmental_cof_switchgear_primary_10kv(
type_env_factor = "Oil",
prox_water = 95, bunded = "Yes")
}
