% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_cables_20_10_04kv.R
\name{pof_cables_20_10_04kv}
\alias{pof_cables_20_10_04kv}
\title{Current Probability of Failure for 20/10/0.4kV cables}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
pof_cables_20_10_04kv(
  hv_lv_cable_type = "10-20kV cable, PEX",
  sub_division = "Aluminium sheath - Aluminium conductor",
  utilisation_pct = "Default",
  operating_voltage_pct = "Default",
  sheath_test = "Default",
  partial_discharge = "Default",
  fault_hist = "Default",
  reliability_factor = "Default",
  age
)
}
\arguments{
\item{hv_lv_cable_type}{String.
A sting that refers to the specific asset category.
Options:
\code{hv_lv_cable_type = c("10-20kV cable, PEX","10-20kV cable, APB",
"0.4kV cable")}. The default setting is
\code{hv_lv_cable_type = "10-20kV cable, PEX"}.}

\item{sub_division}{String. Refers to material the sheath and conductor is
made of. Options:
\code{sub_division = c("Aluminium sheath - Aluminium conductor",
"Aluminium sheath - Copper conductor",
"Lead sheath - Aluminium conductor", "Lead sheath - Copper conductor")
}}

\item{utilisation_pct}{Numeric. The max percentage of utilisation
under normal operating conditions.}

\item{operating_voltage_pct}{Numeric. The ratio in percent of
operating/design voltage.}

\item{sheath_test}{String. Only applied for non pressurised cables.
Indicating the state of the sheath. Options:
\code{sheath_test = c("Pass", "Failed Minor", "Failed Major",
"Default")}. See page 141, table 168 in CNAIM (2017).}

\item{partial_discharge}{String. Only applied for non pressurised cables.
Indicating the level of partial discharge. Options:
\code{partial_discharge = c("Low", "Medium", "High",
 "Default")}. See page 141, table 169 in CNAIM (2017).}

\item{fault_hist}{Numeric. Only applied for non pressurised cables.
The calculated fault rate for the cable in the period per kilometer.
A setting of \code{"No historic faults recorded"}
indicates no fault. See page 141, table 170 in CNAIM (2017).}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 69 in CNAIM (2017).}

\item{age}{Numeric. The current age in years of the cable.}
}
\value{
Numeric. Current probability of failure
per annum for 20/10/0.4kV cables.
}
\description{
This function calculates the current
annual probability of failure per kilometer for a 20/10/0.4kV cable.
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function. For more information about the
probability of failure function see section 6
on page 30 in CNAIM (2017).
}
\examples{
# Current annual probability of failure for 10-20kV cable, APB, 50 years old
pof_cables_10kV_APB <-
pof_cables_20_10_04kv(hv_lv_cable_type = "10-20kV cable, APB",
sub_division = "Lead sheath - Copper conductor",
utilisation_pct = 80,
operating_voltage_pct = 60,
sheath_test = "Default",
partial_discharge = "Default",
fault_hist = "Default",
reliability_factor = "Default",
age = 50) * 100

paste0(sprintf("Probability of failure \%.4f", pof_cables_10kV_APB),
" percent per annum")
}
