% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{print.clme}
\alias{print.clme}
\title{Printout of fitted object.}
\usage{
\method{print}{clme}(x, ...)
}
\arguments{
\item{x}{an object of class \code{clme}.}

\item{...}{space for additional arguments}
}
\value{
Text printed to console.
}
\description{
Prints basic information on a fitted object of class \code{clme}.
}
\examples{
\dontrun{
data( rat.blood )
set.seed( 42 )
cons <- list(order = "simple", decreasing = FALSE, node = 1 )
clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood , 
                 constraints = cons, seed = 42, nsim = 10)

print( clme.out )
}

}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
}
