% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_multiTrt_ate.R
\name{bart_multiTrt_ate}
\alias{bart_multiTrt_ate}
\title{Bayesian Additive Regression Trees (BART) for ATE estimation}
\usage{
bart_multiTrt_ate(y, x, trt, k = 2, discard = "No", ntree = 100,
  ndpost = parent.frame()$ndpost, nskip = 1000)
}
\arguments{
\item{y}{numeric vector for the binary outcome}

\item{x}{dataframe including the treatment indicator and the covariates}

\item{trt}{numeric vector for the treatment indicator}

\item{k}{For binary y, k is the number of prior standard deviations f(x) is away from +/-3. The bigger k is, the more conservative the fitting will be.}

\item{discard}{discarding rules for BART method, inherited from causal_multi_treat.R}

\item{ntree}{The number of trees in the sum}

\item{ndpost}{The number of posterior draws returned}

\item{nskip}{Number of MCMC iterations to be treated as burn in}
}
\value{
list with 2 elements for ATT effect. It contains
\item{ATT12:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATT13:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
list with 3 elements for ATE effect. It contains
\item{ATE12:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATE13:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATE23:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
}
\description{
This function implements the BART method when estimand is ATE. Please use our main function causal_multi_treat.R.
}
\examples{
library(CIMTx)
set.seed(3242019)
idata = data_gen(n = 3, ratio =1,scenario = 1)
trt_ind <- as.numeric(idata$trtdat$trt_ind)
all_vars <- idata$trtdat[, -1] #exclude treatment indicator
y <- idata$Yobs
causal_multi_treat(y = y, x = idata$trtdat,
trt = trt_ind, method = "BART", estimand = "ATE", discard = "No", ndpost = 10)
}
