% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{estimateProb}
\alias{estimateProb}
\title{Estimate the Empirical Probability of Whether Two Set of Cells
from Distinct Batches Belong to the Same Population}
\usage{
estimateProb(
  seu,
  ider,
  batch.var = "Batch",
  n_size = 40,
  n.perm = 5,
  verbose = FALSE
)
}
\arguments{
\item{seu}{A Seurat object.}

\item{ider}{A list returned by the \code{getIDEr} function.}

\item{batch.var}{Character string specifying the metadata column that contains 
batch information. Default is "Batch".}

\item{n_size}{Numeric value indicating the number of cells per group used to 
compute the similarity. Default is 40.}

\item{n.perm}{Numeric value specifying the number of permutations to perform.}

\item{verbose}{Logical. If \code{TRUE}, progress messages are printed. 
Default is \code{FALSE}.}
}
\value{
A Seurat object with additional columns for the IDER-based similarity 
and the empirical probability of rejection.
}
\description{
This function computes the empirical probability that two sets of cells from 
distinct batches belong to the same population, based on the output of \code{getIDEr}.
}
\seealso{
\code{\link{hdbscan.seurat}}, \code{\link{getIDEr}}
}
