% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFtime.R
\name{definition}
\alias{definition}
\alias{properties}
\alias{calendar}
\alias{unit}
\alias{origin}
\alias{timezone}
\alias{offsets}
\alias{resolution}
\title{Properties of a CFtime object}
\usage{
definition(cf)

calendar(cf)

unit(cf)

origin(cf)

timezone(cf)

offsets(cf)

resolution(cf)
}
\arguments{
\item{cf}{CFtime. An instance of \code{CFtime}.}
}
\value{
\code{calendar()} and \code{unit()} return a character string.
\code{origin()} returns a data frame of timestamp elements with a single row
of data. \code{timezone()} returns the datum time zone as a character
string. \code{offsets()} returns a vector of offsets or \code{NULL} if no offsets
have been set.
}
\description{
These functions return the properties of an instance of the
\code{CFtime} class. The properties are all read-only, but offsets can be added
using the \code{+} operator.
}
\section{Functions}{
\itemize{
\item \code{definition()}: The definition string of the CFtime instance

\item \code{calendar()}: The calendar of the CFtime instance

\item \code{unit()}: The unit of the CFtime instance

\item \code{origin()}: The origin of the CFtime instance in timestamp elements

\item \code{timezone()}: The time zone of the datum of the CFtime instance as a character string

\item \code{offsets()}: The offsets of the CFtime instance as a vector

\item \code{resolution()}: The average separation between the offsets in the CFtime instance

}}
\examples{
cf <- CFtime("days since 1850-01-01", "julian", 0:364)
definition(cf)
calendar(cf)
unit(cf)
timezone(cf)
origin(cf)
offsets(cf)
resolution(cf)
}
