% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rCFO.next.R
\name{rCFO.next}
\alias{rCFO.next}
\title{Determination of the dose level for next cohort in the randomized calibration-free odds (rCFO) design for phase I trials}
\usage{
rCFO.next(target, cys, cns, currdose, 
       prior.para = list(alp.prior = target, bet.prior = 1 - target),
       cutoff.eli = 0.95, early.stop = 0.95, seed)
}
\arguments{
\item{target}{the target DLT rate.}

\item{cys}{the cumulative numbers of DLTs observed at the left, current, and right dose levels.}

\item{cns}{the cumulative numbers of patients treated at the left, current, and right dose levels.}

\item{currdose}{the current dose level.}

\item{prior.para}{the prior parameters for a beta distribution, where set as \code{list(alp.prior = target, bet.prior = 1 - target)}
by default, \code{alp.prior} and \code{bet.prior} represent the parameters of the prior distribution for
the true DLT rate at any dose level. This prior distribution is specified as Beta(\code{alpha.prior}, \code{beta.prior}).}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of \code{cutoff.eli = 0.95} for general use.}

\item{early.stop}{the threshold value for early stopping. The default value \code{early.stop = 0.95}
generally works well.}

\item{seed}{an integer to be set as the seed of the random number generator for reproducible results. The default value is set to \code{NULL}.}
}
\value{
The \code{rCFO.next()} function returns a list object comprising the following elements:
\itemize{
\item target: the target DLT rate.
\item cys: the cumulative counts of DLTs observed at the left, current, and right dose levels.
\item cns: the cumulative counts of patients treated at the left, current, and right dose levels.
\item decision: the decision in the CFO design, where \code{left}, \code{stay}, and \code{right} represent the
movement directions, and \code{stop} indicates stopping the experiment.
\item currdose: the current dose level.
\item nextdose: the recommended dose level for the next cohort. \code{nextdose = 99} indicates that the trial is
terminated due to early stopping.
\item overtox: the situation regarding which positions experience over-toxicity. The dose level indicated
by \code{overtox} and all the dose levels above experience over-toxicity. \code{overtox = NA} signifies that
the occurrence of over-toxicity did not happen.
\item toxprob: the expected toxicity probability, \eqn{Pr(p_k > \phi | x_k, m_k)}, at the left, current, and
right dose levels, where \eqn{p_k}, \eqn{x_k}, and \eqn{m_k} is the dose-limiting toxicity (DLT) rate, the
numbers of observed DLTs, and the numbers of patients at dose level \eqn{k}. \code{NA} indicates that there
are no patients at the corresponding dose level.
}
}
\description{
In the rCFO design for phase I trials, the function is used to determine the dose movement based on the toxicity outcomes of the enrolled cohorts.
}
\details{
The original CFO design makes deterministic dose movement by constructing two odds ratios, \eqn{\pi_L =O_C/ \overline{O}_{L}}
and \eqn{\pi_R =\overline{O}_{C}/ O_R}, and comparing them against thresholds \eqn{\gamma_L} and \eqn{\gamma_R}, respectively.
The rCFO design introduces a randomization scheme, normalizes odds ratios, \eqn{\pi_L}, and \eqn{\pi_R} into probabilities, and constructs
probabilities for dose escalation, de-escalation, and staying at the same dose.
}
\note{
When the current dose level is the lowest or highest (i.e., at the boundary), the parts in \code{cys} and
\code{cns} where there is no data are filled with \code{NA}. \cr
The dose level indicated by \code{overtox} and all the dose levels above experience over-toxicity, and these dose levels will be eliminated.
}
\examples{
## determine the dose level for the next cohort of new patients
cys <- c(0, 1, 0); cns <- c(3, 6, 0)
decision <- rCFO.next(target=0.2, cys=cys, cns=cns, currdose=3)
summary(decision)

cys <- c(NA, 3, 0); cns <- c(NA, 3, 0)
decision <- rCFO.next(target=0.2, cys=cys, cns=cns, currdose=1)
summary(decision)

cys <- c(0, 3, NA); cns <- c(3, 3, NA)
decision <- rCFO.next(target=0.2, cys=cys, cns=cns, currdose=7)
summary(decision)

}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066.
}
\author{
Jialu Fang, Ninghao Zhang, Wenliang Wang, and Guosheng Yin
}
