% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateCohortSet.R
\name{recordCohortAttrition}
\alias{recordCohortAttrition}
\alias{record_cohort_attrition}
\title{Add attrition reason to a GeneratedCohortSet object}
\usage{
recordCohortAttrition(cohort, reason, cohortId = NULL)

record_cohort_attrition(cohort, reason, cohortId = NULL)
}
\arguments{
\item{cohort}{A generated cohort set}

\item{reason}{The reason for attrition as a character string}

\item{cohortId}{Cohort definition id of the cohort you want to update the
attrition}
}
\value{
The cohort object with the attributes created or updated.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\description{
Update the cohort attrition table with new counts and a reason for attrition.
}
\examples{
\dontrun{
library(CDMConnector)
library(dplyr)

con <- DBI::dbConnect(duckdb::duckdb(), eunomia_dir())
cdm <- cdm_from_con(con = con, cdm_schema = "main", write_schema = "main")
cdm <- generateConceptCohortSet(
  cdm = cdm, conceptSet = list(pharyngitis = 4112343), name = "new_cohort"
)

cohortSet(cdm$new_cohort)
cohortCount(cdm$new_cohort)
cohortAttrition(cdm$new_cohort)

cdm$new_cohort <- cdm$new_cohort \%>\%
  filter(cohort_start_date >= as.Date("2010-01-01"))

cdm$new_cohort <- updateCohortAttributes(
  cohort = cdm$new_cohort, reason = "Only events after 2010"
)

cohortSet(cdm$new_cohort)
cohortCount(cdm$new_cohort)
cohortAttrition(cdm$new_cohort)
}
}
