% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdm.R
\name{stow}
\alias{stow}
\title{Collect a list of lazy queries and save the results as files}
\usage{
stow(cdm, path, format = "parquet")
}
\arguments{
\item{cdm}{A cdm object}

\item{path}{A folder to save the cdm object to}

\item{format}{The file format to use: "parquet", "csv", "feather", "duckdb".}
}
\value{
Invisibly returns the cdm input
}
\description{
Collect a list of lazy queries and save the results as files
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(), dbdir = eunomia_dir())
vocab <- cdm_from_con(con, cdm_tables = c("concept", "concept_ancestor"))
stow(vocab, here::here("vocab_tables"))
DBI::dbDisconnect(con, shutdown = TRUE)
}
}
