% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_MAs}
\alias{load_MAs}
\title{Load CCAMLR Management Areas}
\usage{
load_MAs()
}
\description{
Download the up-to-date spatial layer from the \href{http://gis.ccamlr.org/}{online CCAMLRGIS} and load it to your environment.
The layer's Metadata is accessible by clicking on the red 'i' in the list of layers available on the \href{http://gis.ccamlr.org/}{online CCAMLRGIS}.
See examples for offline use.
}
\examples{
 
\donttest{

#When online:
MAs=load_MAs()
plot(MAs)

#If going offline in the future: load and save as RData when online,
# then reload RData when offline:
MAs=load_MAs()
EEZs=load_EEZs()
save(list=c('MAs','EEZs'), file = file.path(tempdir(), "CCAMLRLayers.RData"))
rm(MAs,EEZs)
load(file.path(tempdir(), "CCAMLRLayers.RData"))

}

}
\seealso{
\code{\link{load_ASDs}}, \code{\link{load_SSRUs}}, \code{\link{load_RBs}},
\code{\link{load_SSMUs}}, \code{\link{load_Coastline}},
\code{\link{load_RefAreas}}, \code{\link{load_MPAs}}, \code{\link{load_EEZs}}.
}
