% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions_rsq.R
\name{make_numeric}
\alias{make_numeric}
\title{Turning a non-numeric variable into a numeric one}
\usage{
make_numeric(vari, outcome, ra,mode)
}
\arguments{
\item{vari}{array of values to be transformed}

\item{outcome}{TRUE/FALSE indicates whether the variable \code{vari} is an outcome (TRUE) or a predictor (FALSE)}

\item{ra}{indices of the input array \code{vari} which indicate which values will be transformed}

\item{mode}{\code{'binary'} (logistic regression), \code{'multin'} (multinomial regression)}
}
\value{
Returned value is an M x N matrix where M is the length of the input array of indices \code{ra} and N is \code{length(vari)-1}.
}
\description{
Function which turns a single categorical (non-numeric) variable into a numeric one (or several) by introducing dummy '0'/'1' variables.
}
\details{
This function is essentially a standard way to turn categorical non-numeric variables into numeric ones in order to run a regression
}
\examples{
#creating a non-numeric set

a<-t(rmultinom(100,1,c(0.2,0.3,0.5)))\%*\%c(1,2,3)

a[a==1]='red'
a[a==2]='green'
a[a==3]='blue'

#running the function

make_numeric(a,FALSE,sample(1:100,50),"linear")

make_numeric(a,TRUE,sample(1:100,50))
}
