#' summary.CAISErPowercurve
#'
#' S3 method for summarizing _caiser.powercurve_ objects (the output of
#' [calc_power_curve()]).
#'
#' @param object list object of class _caiser.powercurve_
#'                     (generated by [calc_power_curve()])
#' @param ... other parameters to be passed down to specific summary
#'            functions (currently unused)
#'
#' @examples
#' my.cpc <- calc_power_curve(ninstances = 10)
#' summary(my.cpc)
#'
#' @export
#'

# TESTED
summary.CAISErPowercurve <- function(object,...)
{

  # ========== Error catching ========== #
  assertthat::assert_that(
    "CAISErPowercurve" %in% class(object),
    length(object$d) == length(object$power))
  # ==================================== #

  npts <- length(object$d)
  i50 <- which.min(abs(object$power - 0.50))
  i80 <- which.min(abs(object$power - 0.80))
  i95 <- which.min(abs(object$power - 0.95))

  cat("#====================================")
  cat("\n Number of points: ", npts)
  cat("\n power = ", signif(object$power[i50], 2),
      "for d = ", signif(object$d[i50], 2))
  cat("\n power = ", signif(object$power[i80], 2),
      "for d = ", signif(object$d[i80], 2))
  cat("\n power = ", signif(object$power[i95], 2),
      "for d = ", signif(object$d[i95], 2))
  cat("\n#====================================")

  output <- data.frame(d     = c(object$d[i50],
                                 object$d[i80],
                                 object$d[i95]),
                       power = c(object$power[i50],
                                 object$power[i80],
                                 object$power[i95]))
  invisible(output)
}
