/*
 * PreferencesDialog.java
 *
 * Created on October 3, 2005, 8:27 AM
 */

package org.neptuneinc.cadstat.prefs;

import org.neptuneinc.cadstat.prefs.PreferencesManager;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeListener;

/**
 *
 * @author  Pasha Minallah
 */
public class PreferencesDialog extends javax.swing.JDialog implements ActionListener, ChangeListener
{
  public static final Float MAGNIFICATION_FACTOR = 4.0F;
  
  private PreferencesManager prefsManager;
  private boolean settingsChanged;
  
  /** Creates new form PreferencesDialog */
  public PreferencesDialog()
  {
    super();
    initComponents();
    
    initCustom();
  }
  
  /** Perform custom initialization. */
  protected void initCustom()
  {
    dataPointColor.setModel(new DefaultComboBoxModel(DataPointColor.values()));
    plotChar.setModel(new DefaultComboBoxModel(PlotCharacter.values()));
    
    prefsManager = new PreferencesManager();
    this.importPreferences();
    
    dataPointColor.addActionListener(this);
    plotChar.addActionListener(this);
    magPlotTitle.addChangeListener(this);
    magAxis.addChangeListener(this);
    magAxisLabel.addChangeListener(this);
    magDataPoint.addChangeListener(this);
    
    this.setSettingsChanged(false);
    
    updateValidity();
    
    this.getRootPane().setDefaultButton(saveButton);
  }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    tabbedPane = new javax.swing.JTabbedPane();
    plotPane = new javax.swing.JPanel();
    generalPane = new javax.swing.JPanel();
    jLabel1 = new javax.swing.JLabel();
    dataPointColor = new javax.swing.JComboBox();
    jLabel2 = new javax.swing.JLabel();
    plotChar = new javax.swing.JComboBox();
    magPane = new javax.swing.JPanel();
    jLabel4 = new javax.swing.JLabel();
    magPlotTitle = new javax.swing.JSlider();
    jLabel5 = new javax.swing.JLabel();
    magAxis = new javax.swing.JSlider();
    jLabel6 = new javax.swing.JLabel();
    magAxisLabel = new javax.swing.JSlider();
    jLabel7 = new javax.swing.JLabel();
    magDataPoint = new javax.swing.JSlider();
    buttonPane = new javax.swing.JPanel();
    cancelButton = new javax.swing.JButton();
    saveButton = new javax.swing.JButton();
    applyButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
    setTitle("Preferences");

    generalPane.setBorder(javax.swing.BorderFactory.createTitledBorder("General"));

    jLabel1.setLabelFor(dataPointColor);
    jLabel1.setText("Data Point Color");

    jLabel2.setLabelFor(plotChar);
    jLabel2.setText("Plotting Character");

    org.jdesktop.layout.GroupLayout generalPaneLayout = new org.jdesktop.layout.GroupLayout(generalPane);
    generalPane.setLayout(generalPaneLayout);
    generalPaneLayout.setHorizontalGroup(
      generalPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(generalPaneLayout.createSequentialGroup()
        .addContainerGap()
        .add(generalPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(generalPaneLayout.createSequentialGroup()
            .add(jLabel2)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(plotChar, 0, 149, Short.MAX_VALUE))
          .add(generalPaneLayout.createSequentialGroup()
            .add(jLabel1)
            .add(21, 21, 21)
            .add(dataPointColor, 0, 149, Short.MAX_VALUE)))
        .addContainerGap())
    );
    generalPaneLayout.setVerticalGroup(
      generalPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(generalPaneLayout.createSequentialGroup()
        .add(generalPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
          .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .add(dataPointColor, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(generalPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(plotChar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
          .add(jLabel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 23, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    magPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Magnification"));

    jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
    jLabel4.setLabelFor(magPlotTitle);
    jLabel4.setText("Plot Title");

    magPlotTitle.setMajorTickSpacing(2);
    magPlotTitle.setMaximum(12);
    magPlotTitle.setMinimum(2);
    magPlotTitle.setMinorTickSpacing(1);
    magPlotTitle.setValue(4);
    magPlotTitle.setPreferredSize(new java.awt.Dimension(80, 16));

    jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
    jLabel5.setLabelFor(magAxis);
    jLabel5.setText("Axis");

    magAxis.setMajorTickSpacing(2);
    magAxis.setMaximum(12);
    magAxis.setMinimum(2);
    magAxis.setMinorTickSpacing(1);
    magAxis.setValue(4);
    magAxis.setPreferredSize(new java.awt.Dimension(80, 16));

    jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
    jLabel6.setLabelFor(magAxisLabel);
    jLabel6.setText("Axis Label");

    magAxisLabel.setMajorTickSpacing(2);
    magAxisLabel.setMaximum(12);
    magAxisLabel.setMinimum(2);
    magAxisLabel.setMinorTickSpacing(1);
    magAxisLabel.setValue(4);
    magAxisLabel.setPreferredSize(new java.awt.Dimension(80, 16));

    jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
    jLabel7.setLabelFor(magDataPoint);
    jLabel7.setText("Data Point");

    magDataPoint.setMajorTickSpacing(2);
    magDataPoint.setMaximum(12);
    magDataPoint.setMinimum(2);
    magDataPoint.setMinorTickSpacing(1);
    magDataPoint.setValue(4);
    magDataPoint.setPreferredSize(new java.awt.Dimension(80, 16));

    org.jdesktop.layout.GroupLayout magPaneLayout = new org.jdesktop.layout.GroupLayout(magPane);
    magPane.setLayout(magPaneLayout);
    magPaneLayout.setHorizontalGroup(
      magPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(magPaneLayout.createSequentialGroup()
        .addContainerGap()
        .add(magPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(magPaneLayout.createSequentialGroup()
            .add(magPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
              .add(jLabel4)
              .add(jLabel5))
            .add(20, 20, 20)
            .add(magPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
              .add(magAxis, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 197, Short.MAX_VALUE)
              .add(magPlotTitle, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 197, Short.MAX_VALUE)))
          .add(magPaneLayout.createSequentialGroup()
            .add(magPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
              .add(jLabel7)
              .add(jLabel6))
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(magPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
              .add(magDataPoint, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 196, Short.MAX_VALUE)
              .add(magAxisLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 196, Short.MAX_VALUE))))
        .addContainerGap())
    );
    magPaneLayout.setVerticalGroup(
      magPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(magPaneLayout.createSequentialGroup()
        .add(magPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(jLabel4)
          .add(magPlotTitle, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(magPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(jLabel5)
          .add(magAxis, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(magPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
          .add(jLabel6)
          .add(magAxisLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(magPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(jLabel7)
          .add(magDataPoint, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    org.jdesktop.layout.GroupLayout plotPaneLayout = new org.jdesktop.layout.GroupLayout(plotPane);
    plotPane.setLayout(plotPaneLayout);
    plotPaneLayout.setHorizontalGroup(
      plotPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(plotPaneLayout.createSequentialGroup()
        .addContainerGap()
        .add(plotPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(org.jdesktop.layout.GroupLayout.TRAILING, generalPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .add(org.jdesktop.layout.GroupLayout.TRAILING, magPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addContainerGap())
    );
    plotPaneLayout.setVerticalGroup(
      plotPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(plotPaneLayout.createSequentialGroup()
        .addContainerGap()
        .add(generalPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(magPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    tabbedPane.addTab("Plot", plotPane);

    cancelButton.setText("Cancel");
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    saveButton.setText("Save");
    saveButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        saveButtonActionPerformed(evt);
      }
    });

    applyButton.setText("Apply");
    applyButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        applyButtonActionPerformed(evt);
      }
    });

    org.jdesktop.layout.GroupLayout buttonPaneLayout = new org.jdesktop.layout.GroupLayout(buttonPane);
    buttonPane.setLayout(buttonPaneLayout);
    buttonPaneLayout.setHorizontalGroup(
      buttonPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(buttonPaneLayout.createSequentialGroup()
        .add(30, 30, 30)
        .add(cancelButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 86, Short.MAX_VALUE)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
        .add(saveButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 75, Short.MAX_VALUE)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
        .add(applyButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 81, Short.MAX_VALUE)
        .add(40, 40, 40))
    );
    buttonPaneLayout.setVerticalGroup(
      buttonPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(buttonPaneLayout.createSequentialGroup()
        .addContainerGap()
        .add(buttonPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(saveButton)
          .add(applyButton)
          .add(cancelButton))
        .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
        .addContainerGap()
        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
          .add(org.jdesktop.layout.GroupLayout.LEADING, tabbedPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 336, Short.MAX_VALUE)
          .add(org.jdesktop.layout.GroupLayout.LEADING, buttonPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
        .addContainerGap()
        .add(tabbedPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 265, Short.MAX_VALUE)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
        .add(buttonPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        .addContainerGap())
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents
  
  private void importPreferences()
  {
    try
    {
      prefsManager.importPreferences();
    }
    catch (Exception ex)
    {
      Logger.getLogger(PreferencesDialog.class.getName()).log(Level.INFO, null, ex);
    }
    
    dataPointColor.setSelectedItem(prefsManager.getCadstatPreferences().getDataPointColor());
    plotChar.setSelectedItem(prefsManager.getCadstatPreferences().getPlotCharacter());
    magPlotTitle.setValue(Math.round(prefsManager.getCadstatPreferences().getPlotTitleMagnification() * MAGNIFICATION_FACTOR));
    magAxis.setValue(Math.round(prefsManager.getCadstatPreferences().getAxisMagnification() * MAGNIFICATION_FACTOR));
    magAxisLabel.setValue(Math.round(prefsManager.getCadstatPreferences().getAxisLabelMagnification() * MAGNIFICATION_FACTOR));
    magDataPoint.setValue(Math.round(prefsManager.getCadstatPreferences().getDataPointMagnification() * MAGNIFICATION_FACTOR));
  }
  
  private void exportPreferences()
  {
    prefsManager.getCadstatPreferences().setDataPointColor((DataPointColor) dataPointColor.getSelectedItem());
    prefsManager.getCadstatPreferences().setPlotCharacter((PlotCharacter) plotChar.getSelectedItem());
    prefsManager.getCadstatPreferences().setPlotTitleMagnification(magPlotTitle.getValue() / MAGNIFICATION_FACTOR);
    prefsManager.getCadstatPreferences().setAxisMagnification(magAxis.getValue() / MAGNIFICATION_FACTOR);
    prefsManager.getCadstatPreferences().setAxisLabelMagnification(magAxisLabel.getValue() / MAGNIFICATION_FACTOR);
    prefsManager.getCadstatPreferences().setDataPointMagnification(magDataPoint.getValue() / MAGNIFICATION_FACTOR);
    
    try
    {
      prefsManager.exportPreferences();
    }
    catch (FileNotFoundException ex)
    {
      Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
    }
    catch (IOException ex)
    {
      Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
    }
    catch (BackingStoreException ex)
    {
      Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
    }
  }
  
  private void processSettingChange()
  {
    this.setSettingsChanged(true);
    
    updateValidity();
  }
  
  @Override
  public void actionPerformed(java.awt.event.ActionEvent actionEvent)
  {
    processSettingChange();
  }
  
  @Override
  public void stateChanged(javax.swing.event.ChangeEvent changeEvent)
  {
    processSettingChange();
  }
  
  private void saveButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_saveButtonActionPerformed
  {//GEN-HEADEREND:event_saveButtonActionPerformed
    this.exportPreferences();
    
    this.dispose();
  }//GEN-LAST:event_saveButtonActionPerformed
  
  private void applyButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_applyButtonActionPerformed
  {//GEN-HEADEREND:event_applyButtonActionPerformed
    this.exportPreferences();
    
    this.setSettingsChanged(false);
    
    updateValidity();
  }//GEN-LAST:event_applyButtonActionPerformed
  
  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_cancelButtonActionPerformed
  {//GEN-HEADEREND:event_cancelButtonActionPerformed
    this.dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed
  
  private void updateValidity()
  {
    applyButton.setEnabled(this.isSettingsChanged());
  }
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton applyButton;
  private javax.swing.JPanel buttonPane;
  private javax.swing.JButton cancelButton;
  private javax.swing.JComboBox dataPointColor;
  private javax.swing.JPanel generalPane;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JLabel jLabel4;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JLabel jLabel6;
  private javax.swing.JLabel jLabel7;
  private javax.swing.JSlider magAxis;
  private javax.swing.JSlider magAxisLabel;
  private javax.swing.JSlider magDataPoint;
  private javax.swing.JPanel magPane;
  private javax.swing.JSlider magPlotTitle;
  private javax.swing.JComboBox plotChar;
  private javax.swing.JPanel plotPane;
  private javax.swing.JButton saveButton;
  private javax.swing.JTabbedPane tabbedPane;
  // End of variables declaration//GEN-END:variables
  
  protected boolean isSettingsChanged()
  {
    return settingsChanged;
  }

  protected void setSettingsChanged(boolean settingsChanged)
  {
    this.settingsChanged = settingsChanged;
  }

}
