# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title C++ function performing the pairwise comparison over several endpoints. 
#' @description \code{GPC_cpp} call for each endpoint and each strata the pairwise comparison function suited to the type of endpoint and store the results. 
#' @name GPC_cpp
#' 
#' @param endpoint A matrix containing the values of each endpoint (in columns) for each observation (in rows). 
#' @param status A matrix containing the values of the status variables relative to each endpoint (in columns) for each observation (in rows).
#' @param indexC A list containing, for each strata, which rows of the endpoint and status matrices corresponds to the control observations. Not unique when bootstraping.
#' @param posC A list containing, for each strata, the unique identifier of each control observations. 
#' @param indexT A list containing, for each strata, which rows of the endpoint and status matrices corresponds to the treatment observations. Not unique when bootstraping.
#' @param posT A list containing, for each strata, the unique identifier of each treatment observations.
#' @param threshold Store the thresholds associated to each endpoint. Must have length D. The threshold is ignored for binary endpoints. 
#' @param restriction Store the restriction time associated to each endpoint. Must have length D. 
#' @param weightEndpoint Store the weight associated to each endpoint. Must have length D. 
#' @param weightObs A vector containing the weight associated to each observation.
#' @param method The index of the method used to score the pairs. Must have length D. 1 for binary/continuous, 2 for Gaussian, 3/4 for Gehan (left or right-censoring), and 5/6 for Peron (right-censoring survival or competing risks).
#' @param pool The index of the method used to pool results across strata. Can be 0 (weight inversely proportional to the sample size), 1 (Mantel Haenszel weights), 2 (equal weights), 3 (precision weights)
#' @param op The index of the operator used to score the pairs. Must have length D. 1 for larger is beter, -1 for smaller is better.
#' @param D The number of endpoints.
#' @param D_UTTE The number of distinct time to event endpoints.
#' @param n_strata The number of strata. 
#' @param nUTTE_analyzedPeron_M1 The number of unique time-to-event endpoints that have been analyzed the Peron scoring rule before the current endpoint. Must have length D.
#' @param index_endpoint The position of the endpoint at each priority in the argument endpoint. Must have length D. 
#' @param index_status The position of the status at each priority in the argument status. Must have length D. 
#' @param index_UTTE The position, among all the unique tte endpoints, of the TTE endpoints. Equals -1 for non tte endpoints. Must have length n_TTE. 
#' @param list_survTimeC A list of matrix containing the survival estimates (-threshold, 0, +threshold ...) for each event of the control group (in rows).
#' @param list_survTimeT A list of matrix containing the survival estimates (-threshold, 0, +threshold ...) for each event of the treatment group (in rows).
#' @param list_survJumpC A list of matrix containing the survival estimates and survival jumps when the survival for the control arm jumps.
#' @param list_survJumpT A list of matrix containing the survival estimates and survival jumps when the survival for the treatment arm jumps.
#' @param list_lastSurv A list of matrix containing the last survival estimate in each strata (rows) and treatment group (columns).
#' @param p_C Number of nuisance parameter in the survival model for the control group, for each endpoint and strata
#' @param p_T Number of nuisance parameter in the survival model for the treatment group, for each endpoint and strata
#' @param iid_survJumpC A list of matrix containing the iid of the survival estimates in the control group.
#' @param iid_survJumpT A list of matrix containing the iid of the survival estimates in the treatment group.
#' @param zeroPlus Value under which doubles are considered 0?
#' @param correctionUninf Should the uninformative weight be re-distributed to favorable and unfavorable?
#' @param hierarchical Should only the uninformative pairs be analyzed at the lower priority endpoints (hierarchical GPC)? Otherwise all pairs will be compaired for all endpoint (full GPC).
#' @param hprojection Order of the H-projection used to compute the variance.
#' @param neutralAsUninf Should paired classified as neutral be re-analyzed using endpoints of lower priority? 
#' @param addHalfNeutral Should half of the neutral score be added to the favorable and unfavorable scores?
#' @param keepScore Should the result of each pairwise comparison be kept?
#' @param precompute Have the integrals relative to the survival be already computed and stored in list_survTimeC/list_survTimeT and list_survJumpC/list_survJumpT (derivatives)
#' @param paired In case of paired data, the variance of the summary statistic across strata will be added to the variance of the pooled statistic.
#' @param returnIID Should the iid be computed? Second element: is there any nuisance parameter?
#' @param debug Print messages tracing the execution of the function to help debugging. The amount of messages increase with the value of debug (0-5).
#'
#' @details GPC_cpp implements GPC looping first over endpoints and then over pairs.
#' To handle multiple endpoints, it stores some of the results which can be memory demanding when considering large sample - especially when computing the iid decomposition.
#' GPC2_cpp implements GPC looping first over pairs and then over endpoints. It has rather minimal memory requirement but does not handle correction for uninformative pairs. 
#'
#' @keywords internal
#'
#' @author Brice Ozenne
NULL

#' @name GPC_cpp
#' @export
GPC_cpp <- function(endpoint, status, indexC, posC, indexT, posT, threshold, restriction, weightEndpoint, weightObs, method, pool, op, D, D_UTTE, n_strata, nUTTE_analyzedPeron_M1, index_endpoint, index_status, index_UTTE, list_survTimeC, list_survTimeT, list_survJumpC, list_survJumpT, list_lastSurv, p_C, p_T, iid_survJumpC, iid_survJumpT, zeroPlus, correctionUninf, hierarchical, hprojection, neutralAsUninf, addHalfNeutral, keepScore, precompute, paired, returnIID, debug) {
    .Call(`_BuyseTest_GPC_cpp`, endpoint, status, indexC, posC, indexT, posT, threshold, restriction, weightEndpoint, weightObs, method, pool, op, D, D_UTTE, n_strata, nUTTE_analyzedPeron_M1, index_endpoint, index_status, index_UTTE, list_survTimeC, list_survTimeT, list_survJumpC, list_survJumpT, list_lastSurv, p_C, p_T, iid_survJumpC, iid_survJumpT, zeroPlus, correctionUninf, hierarchical, hprojection, neutralAsUninf, addHalfNeutral, keepScore, precompute, paired, returnIID, debug)
}

#' @name GPC_cpp
#' @export
GPC2_cpp <- function(endpoint, status, indexC, posC, indexT, posT, threshold, restriction, weightEndpoint, weightObs, method, pool, op, D, D_UTTE, n_strata, nUTTE_analyzedPeron_M1, index_endpoint, index_status, index_UTTE, list_survTimeC, list_survTimeT, list_survJumpC, list_survJumpT, list_lastSurv, p_C, p_T, iid_survJumpC, iid_survJumpT, zeroPlus, correctionUninf, hierarchical, hprojection, neutralAsUninf, addHalfNeutral, keepScore, precompute, paired, returnIID, debug) {
    .Call(`_BuyseTest_GPC2_cpp`, endpoint, status, indexC, posC, indexT, posT, threshold, restriction, weightEndpoint, weightObs, method, pool, op, D, D_UTTE, n_strata, nUTTE_analyzedPeron_M1, index_endpoint, index_status, index_UTTE, list_survTimeC, list_survTimeT, list_survJumpC, list_survJumpT, list_lastSurv, p_C, p_T, iid_survJumpC, iid_survJumpT, zeroPlus, correctionUninf, hierarchical, hprojection, neutralAsUninf, addHalfNeutral, keepScore, precompute, paired, returnIID, debug)
}

#' @title C++ Function Computing the Integral Terms for the Peron Method in the survival case. 
#' @description Compute the integral with respect to the jump in survival for pairs where both outcomes are censored.
#' 
#' @param survival [matrix] Contains the jump times in the first column,
#' the survival in the other arm at times plus threshold in the second column,
#' and the jump in survival in the third column.
#' @param start [integer] time at which to start the integral.
#' @param lastSurv [numeric,>0] last survival value for the survival function in the second column.
#' @param lastdSurv [numeric,>0] last survival value for the survival function in the third column.
#' @param returnDeriv [logical] should the derivative regarding the survival parameters be return. 
#' @param derivSurv [matrix] matrix column filled of 0 whose number of rows is the number of parameters of the survival.
#' @param derivSurvD [matrix] matrix column filled of 0 whose number of rows is the number of parameters of the survival used to compute the jumps.
#'
#' @keywords function Cpp internal
#' @author Brice Ozenne
#' @export
.calcIntegralSurv_cpp <- function(survival, start, lastSurv, lastdSurv, returnDeriv, derivSurv, derivSurvD) {
    .Call(`_BuyseTest_calcIntegralSurv_cpp`, survival, start, lastSurv, lastdSurv, returnDeriv, derivSurv, derivSurvD)
}

#' @title C++ Function Computing the Integral Terms for the Peron Method in the presence of competing risks (CR).
#' @description Compute the integral with respect to the jump in CIF for pairs where both outcomes are censored.
#'
#' @param cifJump [matrix] cif[1] = jump times in control group (event of interest), cif[2-3] = CIF of event of interest in group
#' T at times - tau and times + tau, cif[4] : jump in cif of control group at times (event of interest).
#' @param start_val [numeric] Time at which to start the integral.
#' @param stop_val [numeric] Time at which to stop the integral.
#' @param cifTimeT [numeric] CIF of event of interest in group T evaluated at observed time of treatment patient.
#' @param lastCIF [numeric, >0] last value of CIF of event type 1 in group T.
#' @param type [numeric] Indicates the type of integral to compute (1 for wins, 2 for losses, 3 for neutral pairs with two
#' events of interest - integral with t+tau and xi - and 4 for neutral pairs with two events of interest - integral with
#' t+tau and t-tau).
#' @param returnDeriv [logical] should the derivative regarding the survival parameters be return. 
#' @param derivSurv [matrix] matrix column filled of 0 whose number of rows is the number of parameters of the survival.
#' @param derivSurvD [matrix] matrix column filled of 0 whose number of rows is the number of parameters of the survival used to compute the jumps.
#'
#' @keywords function Cpp internal
#' @author Eva Cantagallo
#' @export
.calcIntegralCif_cpp <- function(cifJump, start_val, stop_val, cifTimeT, lastCIF, type, returnDeriv, derivSurv, derivSurvD) {
    .Call(`_BuyseTest_calcIntegralCif_cpp`, cifJump, start_val, stop_val, cifTimeT, lastCIF, type, returnDeriv, derivSurv, derivSurvD)
}

#' @title C++ Function pre-computing the Integral Terms for the Peron Method in the survival case. 
#' @description Compute the integral with respect to the jump in survival for pairs where both outcomes are censored, i.e. \eqn{\int S1(t+\tau) dS2(t)}.
#' @name calcIntegralSurv2_cpp
#' 
#' @param time [numeric vector] vector of jump time for S2.
#' @param survival [numeric vector] the survival at each jump time: \eqn{S1(t+\tau)}.
#' @param dSurvival [numeric vector] the jump in survival at each jump time: \eqn{S2(t+)-S2(t-)}
#' @param index_survival [numeric vector] the position of survival parameter \eqn{S1(t+\tau)} among all parameters relative to S1.
#' @param index_dSurvival1 [numeric vector] the position of survival parameter \eqn{S2(t-)} among all parameters relative to S2.
#' @param index_dSurvival2 [numeric vector] the position of survival parameter \eqn{S2(t+)} among all parameters relative to S2.
#' @param lastSurv [numeric] the value of S1 at the end of the follow-up.
#' @param lastSurv [numeric] the value of S2 at the end of the follow-up.
#' @param iidNuisance [logical] should the derivative of the integral relative to the S1 and S2 parameter be output.
#' @param nJump [integer] the number of jump times relative to S2.
#'
#' @keywords function Cpp internal
#' @author Brice Ozenne
#' @export
calcIntegralSurv2_cpp <- function(time, survival, dSurvival, index_survival, index_dSurvival1, index_dSurvival2, lastSurv, lastdSurv, iidNuisance, nJump) {
    .Call(`_BuyseTest_calcIntegralSurv2_cpp`, time, survival, dSurvival, index_survival, index_dSurvival1, index_dSurvival2, lastSurv, lastdSurv, iidNuisance, nJump)
}

#' Row-wise cumulative sum 
#'
#' @description Fast computation of apply(x,1,cumsum)
#' @param X A matrix.
#' @return A matrix of same size as x.
#' @keywords utilities
.rowCumSum_cpp <- function(X) {
    .Call(`_BuyseTest_rowCumSum_cpp`, X)
}

#' Column-wise cumulative sum 
#'
#' @description Fast computation of apply(x,2,cumsum)
#' @param X A matrix.
#' @return A matrix of same size as x.
#' @keywords utilities
.colCumSum_cpp <- function(X) {
    .Call(`_BuyseTest_colCumSum_cpp`, X)
}

#' Apply cumprod in each row 
#'
#' @description Fast computation of t(apply(x,1,cumprod))
#' @param X A matrix.
#' @return A matrix of same size as x.
#' @keywords utilities
.rowCumProd_cpp <- function(X) {
    .Call(`_BuyseTest_rowCumProd_cpp`, X)
}

#' Substract a vector of values in each column 
#'
#' @description Fast computation of sweep(X, FUN = "-", STATS = center, MARGIN = 1)
#' @param X A matrix.
#' @param center A vector with length the number of rows of X .
#' @return A matrix of same size as x.
#' @keywords utilities
.colCenter_cpp <- function(X, center) {
    .Call(`_BuyseTest_colCenter_cpp`, X, center)
}

#' Substract a vector of values in each row
#'
#' @description Fast computation of sweep(X, FUN = "-", STATS = center, MARGIN = 2)
#' @param X A matrix.
#' @param center A vector with length the number of columns of X.
#' @return A matrix of same size as x.
#' @keywords utilities
.rowCenter_cpp <- function(X, center) {
    .Call(`_BuyseTest_rowCenter_cpp`, X, center)
}

#' Divide by a vector of values in each column 
#'
#' @description Fast computation of sweep(X, FUN = "/", STATS = scale, MARGIN = 1)
#' @param X A matrix.
#' @param scale A vector with length the number of rows of X .
#' @return A matrix of same size as x.
#' @keywords utilities
.colScale_cpp <- function(X, scale) {
    .Call(`_BuyseTest_colScale_cpp`, X, scale)
}

#' Dividy by a vector of values in each row
#'
#' @description Fast computation of sweep(X, FUN = "/", STATS = center, MARGIN = 2)
#' @param X A matrix.
#' @param scale A vector with length the number of columns of X.
#' @return A matrix of same size as x.
#' @keywords utilities
.rowScale_cpp <- function(X, scale) {
    .Call(`_BuyseTest_rowScale_cpp`, X, scale)
}

#' Multiply by a vector of values in each column 
#'
#' @description Fast computation of sweep(X, FUN = "*", STATS = scale, MARGIN = 1)
#' @param X A matrix.
#' @param scale A vector with length the number of rows of X .
#' @return A matrix of same size as x.
#' @keywords utilities
.colMultiply_cpp <- function(X, scale) {
    .Call(`_BuyseTest_colMultiply_cpp`, X, scale)
}

#' Multiply by a vector of values in each row
#'
#' @description Fast computation of sweep(X, FUN = "*", STATS = center, MARGIN = 2)
#' @param X A matrix.
#' @param scale A vector with length the number of columns of X.
#' @return A matrix of same size as x.
#' @keywords utilities
.rowMultiply_cpp <- function(X, scale) {
    .Call(`_BuyseTest_rowMultiply_cpp`, X, scale)
}

