% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerBuyseTest.R
\name{powerBuyseTest}
\alias{powerBuyseTest}
\title{Performing simulation studies with BuyseTest}
\usage{
powerBuyseTest(sim, sample.size, sample.sizeC = NULL,
  sample.sizeT = NULL, n.rep, null = c(0, 1), cpus = 1, seed = 10,
  conf.level = NULL, order.Hprojection = NULL, transformation = NULL,
  trace = 1, ...)
}
\arguments{
\item{sim}{[function] take two arguments:
the sample size in the control group (\code{n.C}) and the sample size in the treatment group (\code{n.C})
and generate datasets. The datasets must be data.table objects.}

\item{sample.size}{[integer vector, >0] the various sample sizes at which the simulation should be perform.
Disregarded if any of the arguments \code{sample.sizeC} or \code{sample.sizeT} are specified.}

\item{sample.sizeC}{[integer vector, >0] the various sample sizes in the control group.}

\item{sample.sizeT}{[integer vector, >0] the various sample sizes in the treatment group.}

\item{n.rep}{[integer, >0] the number of simulations.}

\item{null}{[numeric vector] the null hypothesis to be tested for the net benefit (first element) and the win ratio (second element).}

\item{cpus}{[integer, >0] the number of CPU to use.
Only the permutation test can use parallel computation.
Default value read from \code{BuyseTest.options()}.}

\item{seed}{[integer, >0] the seed to consider for the simulation study.}

\item{conf.level}{[numeric] confidence level for the confidence intervals.
Default value read from \code{BuyseTest.options()}.}

\item{order.Hprojection}{[integer 1,2] the order of the H-project to be used to compute the variance of the net benefit/win ratio.}

\item{transformation}{[logical] should the CI be computed on the logit scale / log scale for the net benefit / win ratio and backtransformed.
Otherwise they are computed without any transformation.
Default value read from \code{BuyseTest.options()}.}

\item{trace}{[integer] should the execution of the function be traced?}

\item{...}{parameters from \code{BuyseTest}.}
}
\description{
Performs a simulation studies for several sample sizes.
Returns estimates, standard errors, confidence intervals and p.values.
}
\examples{
library(data.table)

## using simBuyseTest
powerBuyseTest(sim = simBuyseTest, sample.size = c(100), n.rep = 2,
               formula = treatment ~ bin(toxicity),
               method.inference = "u-statistic", trace = 4)

## using user defined simulation function
simFCT <- function(n.C, n.T){
    out <- data.table(Y=rnorm(n.C+n.T),
                      T=c(rep(1,n.C),rep(0,n.T))
                     )
return(out)
}

powerBuyseTest(sim = simFCT, sample.size = c(100), n.rep = 2,
              formula = T ~ cont(Y), method.inference = "u-statistic", trace = 4)

}
