% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchGLM.R
\name{BranchGLM}
\alias{BranchGLM}
\alias{BranchGLM.fit}
\title{Fits GLMs}
\usage{
BranchGLM(
  formula,
  data,
  family,
  link,
  offset = NULL,
  method = "Fisher",
  grads = 10,
  parallel = FALSE,
  nthreads = 8,
  tol = 1e-06,
  maxit = NULL,
  init = NULL,
  contrasts = NULL,
  keepData = TRUE,
  keepY = TRUE
)

BranchGLM.fit(
  x,
  y,
  family,
  link,
  offset = NULL,
  method = "Fisher",
  grads = 10,
  parallel = FALSE,
  nthreads = 8,
  init = NULL,
  maxit = NULL,
  tol = 1e-06
)
}
\arguments{
\item{formula}{a formula for the model.}

\item{data}{a dataframe that contains the response and predictor variables.}

\item{family}{distribution used to model the data, one of "gaussian", "gamma", "binomial", or "poisson".}

\item{link}{link used to link mean structure to linear predictors. One of
"identity", "logit", "probit", "cloglog", "sqrt", "inverse", or "log".}

\item{offset}{offset vector, by default the zero vector is used.}

\item{method}{one of "Fisher", "BFGS", or "LBFGS". BFGS and L-BFGS are 
quasi-newton methods which are typically faster than Fisher's scoring when
there are many covariates (at least 50).}

\item{grads}{number of gradients used to approximate inverse information with, only for \code{method = "LBFGS"}.}

\item{parallel}{whether or not to make use of parallelization via OpenMP.}

\item{nthreads}{number of threads used with OpenMP, only used if \code{parallel = TRUE}.}

\item{tol}{tolerance used to determine model convergence.}

\item{maxit}{maximum number of iterations performed. The default for 
Fisher's scoring is 50 and for the other methods the default is 200.}

\item{init}{initial values for the betas, if not specified then they are automatically 
selected.}

\item{contrasts}{see \code{contrasts.arg} of \code{model.matrix.default}.}

\item{keepData}{Whether or not to store a copy of data and design matrix, the default 
is TRUE. If this is FALSE, then the results from this cannot be used inside of \code{VariableSelection}.}

\item{keepY}{Whether or not to store a copy of y, the default is TRUE. If 
this is FALSE, then the binomial GLM helper functions may not work and this 
cannot be used inside of \code{VariableSelection}.}

\item{x}{design matrix used for the fit, must be numeric.}

\item{y}{outcome vector, must be numeric.}
}
\value{
\code{BranchGLM} returns a \code{BranchGLM} object which is a list with the following components
\item{\code{coefficients}}{ a matrix with the coefficients estimates, SEs, wald test statistics, and p-values}
\item{\code{iterations}}{ number of iterations it took the algorithm to converge, if the algorithm failed to converge then this is -1}
\item{\code{dispersion}}{ the value of the dispersion parameter}
\item{\code{logLik}}{ the log-likelihood of the fitted model}
\item{\code{resdev}}{ the residual deviance of the fitted model}
\item{\code{AIC}}{ the AIC of the fitted model}
\item{\code{preds}}{ predictions from the fitted model}
\item{\code{linpreds}}{ linear predictors from the fitted model}
\item{\code{formula}}{ formula used to fit the model}
\item{\code{method}}{ iterative method used to fit the model}
\item{\code{y}}{ y vector used in the model, not included if \code{keepY = FALSE}}
\item{\code{x}}{ design matrix used to fit the model, not included if \code{keepData = FALSE}}
\item{\code{offset}}{ offset vector in the model, not included if \code{keepData = FALSE}}
\item{\code{data}}{ original dataframe supplied to the function, not included if \code{keepData = FALSE}}
\item{\code{numobs}}{ number of observations in the design matrix}
\item{\code{names}}{ names of the variables}
\item{\code{yname}}{ name of y variable}
\item{\code{parallel}}{ whether parallelization was employed to speed up model fitting process}
\item{\code{missing}}{ number of missing values removed from the original dataset}
\item{\code{link}}{ link function used to model the data}
\item{\code{family}}{ family used to model the data}
\item{\code{ylevel}}{ the levels of y, only included for binomial glms}
\item{\code{xlev}}{ the levels of the factors in the dataset}
\item{\code{terms}}{the terms object used}

\code{BranchGLM.fit} returns a list with the following components
\item{\code{coefficients}}{ a matrix with the coefficients estimates, SEs, wald test statistics, and p-values}
\item{\code{iterations}}{ number of iterations it took the algorithm to converge, if the algorithm failed to converge then this is -1}
\item{\code{dispersion}}{ the value of the dispersion parameter}
\item{\code{logLik}}{ the log-likelihood of the fitted model}
\item{\code{resdev}}{ the residual deviance of the fitted model}
\item{\code{AIC}}{ the AIC of the fitted model}
\item{\code{preds}}{ predictions from the fitted model}
\item{\code{linpreds}}{ linear predictors from the fitted model}
}
\description{
Fits generalized linear models via RcppArmadillo. Also has the 
ability to fit the models with parallelization via OpenMP.
}
\details{
Can use BFGS, L-BFGS, or Fisher's scoring to fit the GLM. BFGS and L-BFGS are 
typically faster than Fisher's scoring when there are at least 50 covariates 
and Fisher's scoring is typically best when there are fewer than 50 covariates.
This function does not currently support the use of weights. In the special 
case of gaussian regression with identity link the \code{method} argument is ignored
and the normal equations are solved directly.

The models are fit in C++ by using Rcpp and RcppArmadillo. In order to help 
convergence, each of the methods makes use of a backtracking line-search using 
the strong Wolfe conditions to find an adequate step size. There are also 
two conditions used to control convergence, the first is whether there is a 
sufficient decrease in the negative log-likelihood, and the other is whether 
the norm of the score is sufficiently small. The 
\code{tol} argument controls both of these criteria. If the algorithm fails to 
converge, then \code{iterations} will be -1.

All observations with any missing values are removed before model fitting. 

The dispersion parameter for gamma regression is estimated via maximum likelihood, 
very similar to the \code{gamma.dispersion} function from the MASS package.

\code{BranchGLM.fit} can be faster than calling \code{BranchGLM} if the 
x matrix and y vector are already available, but doesn't return as much information.
The object returned by \code{BranchGLM.fit} is not of class \code{BranchGLM}, so 
all of the methods for \code{BranchGLM} objects such as \code{predict} or 
\code{VariableSelection} cannot be used.
}
\examples{
Data <- iris
### Using BranchGLM
BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")
### Using BranchGLM.fit
x <- model.matrix(Sepal.Length ~ ., data = Data)
y <- Data$Sepal.Length
BranchGLM.fit(x, y, family = "gaussian", link = "identity")
}
