% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{indsim}
\alias{indsim}
\title{Simulation time series data for individual}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 50 rows and 10 columns.
}
\usage{
indsim
}
\description{
A dataset containing values of 10 interested
variables over 50 periods.
}
\examples{
## Generated by the following R codes
set.seed(1000)
n = 50; p = 10
Precision = diag(rep(2, p))        # generate precision matrix
for (i in 1 : (p - 1)){
  temp = ifelse(i > 2 * p / 3, 0.4, 1)
  Precision[i, i + 1] = temp
  Precision[i + 1, i] = temp
}
# R=-cov2cor(Precision) + diag(rep(2, p)) # real partial correlation matrix
Sigma = solve(Precision)           # generate covariance matrix
rho = 0.5
y = matrix(0, n, p)                # generate observed time series data
Epsilon = MASS::mvrnorm(n, rep(0, p), Sigma)
y[1, ] = Epsilon[1, ]
for (i in 2 : n){
  y[i, ] = rho * y[i - 1, ] + sqrt(1 - rho^2) * Epsilon[i, ]
}
indsim = y
}
\keyword{datasets}
